/*
 * Decompiled with CFR 0.152.
 */
package asa.camera.math;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class SpringDamper {
    public static float smoothDamp(float current, float target, FloatRef currentVelocity, float smoothTime, float maxSpeed, float deltaTime, boolean allowOvershoot) {
        if (deltaTime <= 1.0E-4f) {
            return current;
        }
        smoothTime = Math.max(1.0E-4f, smoothTime);
        float omega = 2.0f / smoothTime;
        float x = omega * deltaTime;
        float exp = 1.0f / (1.0f + x + 0.48f * x * x + 0.235f * x * x * x);
        float change = current - target;
        float originalTo = target;
        float maxChange = maxSpeed * smoothTime;
        change = Math.max(-maxChange, Math.min(maxChange, change));
        target = current - change;
        float temp = (currentVelocity.value + omega * change) * deltaTime;
        currentVelocity.value = (currentVelocity.value - omega * temp) * exp;
        float output = target + (change + temp) * exp;
        if (!allowOvershoot && originalTo - current > 0.0f == output > originalTo) {
            output = originalTo;
            currentVelocity.value = 0.0f;
        }
        return output;
    }

    public static float smoothDamp(float current, float target, FloatRef currentVelocity, float smoothTime, float maxSpeed, float deltaTime) {
        return SpringDamper.smoothDamp(current, target, currentVelocity, smoothTime, maxSpeed, deltaTime, false);
    }

    @Environment(value=EnvType.CLIENT)
    public static class FloatRef {
        public float value;
    }
}

