/*
 * Decompiled with CFR 0.152.
 */
package com.renapti.minimalcoordshud.client;

import com.renapti.minimalcoordshud.MinimalCoordsHUD;
import com.renapti.minimalcoordshud.config.ModConfig;
import com.renapti.minimalcoordshud.text.Decimals;
import com.renapti.minimalcoordshud.text.Styles;
import java.text.DecimalFormat;
import java.util.Optional;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3675;
import net.minecraft.class_5321;
import net.minecraft.class_7134;

public class MinimalCoordsHUDClient
implements ClientModInitializer {
    private static final ModConfig config = MinimalCoordsHUD.getConfig();
    public static class_304 copyCoords;
    public static class_304 copyInterCoords;
    public static class_304 toggleHUD;

    public static String getFormattedCoordsString(double x, double y, double z) {
        if (config.getDecimalDigitsInCopied()) {
            DecimalFormat decimal = Decimals.decimalToDigits(false);
            return decimal.format(x) + ", " + decimal.format(y) + ", " + decimal.format(z);
        }
        return (int)Math.round(x) + ", " + (int)Math.round(y) + ", " + (int)Math.round(z);
    }

    private static String getStreamerModeKey(String key) {
        return key + (MinimalCoordsHUDClient.config.streamerMode ? ".streamer" : "");
    }

    private static void fatalFailCopy(class_310 mc) {
        assert (mc.field_1724 != null);
        mc.field_1724.method_43496((class_2561)class_2561.method_43471((String)"chat.minimalcoordshud.failed").method_10862(Styles.RED));
        MinimalCoordsHUDClient.playFailSound(mc);
    }

    private static void playFailSound(class_310 mc) {
        if (MinimalCoordsHUDClient.config.playIndicatorSounds) {
            assert (mc.field_1724 != null);
            mc.field_1724.method_17356((class_3414)class_3417.field_15204.comp_349(), class_3419.field_15248, 0.75f, 0.5f);
        }
    }

    public static void playSuccessSound(class_310 mc) {
        if (MinimalCoordsHUDClient.config.playIndicatorSounds) {
            assert (mc.field_1724 != null);
            mc.field_1724.method_17356(class_3417.field_14895, class_3419.field_15248, 0.5f, 1.0f);
        }
    }

    public static void copyCoords(class_310 mc) {
        assert (mc.field_1724 != null);
        String copied = MinimalCoordsHUDClient.getFormattedCoordsString(mc.field_1724.method_23317(), mc.field_1724.method_23318(), mc.field_1724.method_23321());
        mc.field_1724.method_43496((class_2561)class_2561.method_43469((String)MinimalCoordsHUDClient.getStreamerModeKey("chat.minimalcoordshud.copied"), (Object[])new Object[]{copied}).method_10862(Styles.LIGHT_BLUE));
        mc.field_1774.method_1455(copied);
        MinimalCoordsHUDClient.playSuccessSound(mc);
    }

    private static void copyInterCoords(class_310 mc) {
        String copied;
        assert (mc.field_1724 != null);
        Optional dimensionRaw = mc.field_1724.method_37908().method_40134().method_40230();
        if (!dimensionRaw.isPresent()) {
            MinimalCoordsHUDClient.fatalFailCopy(mc);
            return;
        }
        class_5321 dimension = (class_5321)dimensionRaw.get();
        if (dimension.equals(class_7134.field_37667)) {
            copied = MinimalCoordsHUDClient.getFormattedCoordsString(mc.field_1724.method_23317() * 8.0, mc.field_1724.method_23318(), mc.field_1724.method_23321() * 8.0);
            mc.field_1724.method_43496((class_2561)class_2561.method_43469((String)MinimalCoordsHUDClient.getStreamerModeKey("chat.minimalcoordshud.copied.overworld"), (Object[])new Object[]{copied}).method_10862(Styles.LIGHT_BLUE));
        } else if (dimension.equals(class_7134.field_37666)) {
            copied = MinimalCoordsHUDClient.getFormattedCoordsString(mc.field_1724.method_23317() / 8.0, mc.field_1724.method_23318(), mc.field_1724.method_23321() / 8.0);
            mc.field_1724.method_43496((class_2561)class_2561.method_43469((String)MinimalCoordsHUDClient.getStreamerModeKey("chat.minimalcoordshud.copied.nether"), (Object[])new Object[]{copied}).method_10862(Styles.LIGHT_BLUE));
        } else {
            if (dimension.equals(class_7134.field_37668)) {
                mc.field_1724.method_43496((class_2561)class_2561.method_43471((String)"hud.minimalcoordshud.failed.end").method_10862(Styles.YELLOW));
                MinimalCoordsHUDClient.playFailSound(mc);
                return;
            }
            MinimalCoordsHUDClient.fatalFailCopy(mc);
            return;
        }
        mc.field_1774.method_1455(copied);
        MinimalCoordsHUDClient.playSuccessSound(mc);
    }

    public void onInitializeClient() {
        copyCoords = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.minimalcoordshud.copycoords", class_3675.class_307.field_1668, 46, "category.minimalcoordshud.main"));
        copyInterCoords = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.minimalcoordshud.copycoords.interdimensional", class_3675.class_307.field_1668, 44, "category.minimalcoordshud.main"));
        toggleHUD = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.minimalcoordshud.togglehud", class_3675.class_307.field_1668, 77, "category.minimalcoordshud.main"));
        ClientTickEvents.END_CLIENT_TICK.register(mc -> {
            if (copyCoords.method_1436()) {
                MinimalCoordsHUDClient.copyCoords(mc);
            } else if (copyInterCoords.method_1436()) {
                MinimalCoordsHUDClient.copyInterCoords(mc);
            }
            while (toggleHUD.method_1436()) {
                MinimalCoordsHUDClient.config.isHUDToggled = !MinimalCoordsHUDClient.config.isHUDToggled;
            }
        });
    }
}

