/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.harmonysymbioticascension;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.mcreator.harmonysymbioticascension.entity.ShifterEntity;
import net.mcreator.harmonysymbioticascension.init.HarmonySymbioticAscensionModEntities;
import net.mcreator.harmonysymbioticascension.network.HarmonySymbioticAscensionModVariables;
import net.mcreator.harmonysymbioticascension.procedures.InfectorOnIntinalSpawnProcedure;
import net.mcreator.harmonysymbioticascension.procedures.ShifterOnInitialEntitySpawnProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class InfectionManager {
    public static final String MODID = "harmony_symbiotic_ascension";
    private static final int TOTAL_STAGES = 3;
    private static final int MULTIPLIED_POINTS_PER_STAGE = 100;
    private static final double TICKS_PER_DAY = 27000.0;
    private static final long DAYS_TO_FIRST_STAGE = 16L;
    private static final long DAYS_TO_SECOND_STAGE = 36L;
    private static final long DAYS_TO_THIRD_STAGE = 86L;
    private static final double BASE_POINTS_PER_TICK = 2.314814814814815E-4;
    private static final double AFTER_FIRST_KINGDOM_BASE_POINTS_PER_TICK = 1.0288065843621399E-4;
    private static final double MIN_SPAWN_MULTIPLIER = 0.01;
    private static final double MAX_SPAWN_MULTIPLIER = 1.0;
    private static final double[] STAGE_SUPPRESSION = new double[]{0.98, 0.7, 0.4};
    private static final double INFECTED_ENTITY_POINT_BONUS = 2.0E-5;
    private static final double INFECTED_SEARCH_RADIUS = 72.0;
    private static final int INITIAL_SHIFTER_INTERVAL = 2400;
    private static final double MAX_POINTS_TO_FIRST_STAGE = 300.0;
    private static final Map<ServerLevel, List<CachedMob>> recentMobs = new HashMap<ServerLevel, List<CachedMob>>();
    private static final Map<ServerLevel, List<CachedMob>> mobCache = new HashMap<ServerLevel, List<CachedMob>>();
    private static final Map<ServerLevel, Integer> recentIndex = new HashMap<ServerLevel, Integer>();
    private static final Map<ServerLevel, Integer> infectorIndex = new HashMap<ServerLevel, Integer>();
    private static final Map<ServerLevel, Map<ServerPlayer, List<LivingEntity>>> nearbyMobsCache = new HashMap<ServerLevel, Map<ServerPlayer, List<LivingEntity>>>();
    private static final int MOB_CACHE_TICKS = 100;
    private static final int RECENT_MOB_TIMEOUT_TICKS = 80;
    private static int infectorsSpawnedThisTick = 0;
    public static double currentSymbionts = 0.0;
    private static final int MAX_INFECTORS_PER_TICK = 3;
    private static final int RECENT_SPAWN_TICKS = 160;
    private static final double MAX_RECENT_SPAWN_PENALTY = 0.465;
    private static final String NBT_INFECTOR_SPAWNED = "HasSpawnedInfector";
    private static final int LURKER_RETARGET_TICKS = 360;
    private static final int LURKER_MAX_DIST = 8;
    private static final int LURKER_MIN_PLAYER_DIST = 5;
    private static final TagKey<EntityType<?>> SYMBIONT_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("harmony:symbionts"));
    private static final TagKey<EntityType<?>> ROBOT_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("btw:empire"));
    private static final TagKey<EntityType<?>> NO_ENTITIES_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("minecraft:no_entities"));

    private static EntityType<?> getShifter() {
        return (EntityType)HarmonySymbioticAscensionModEntities.SHIFTER.get();
    }

    private static EntityType<?> getInfector() {
        return (EntityType)HarmonySymbioticAscensionModEntities.INFECTOR.get();
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new InfectionManager());
    }

    private static Map<ServerPlayer, List<LivingEntity>> getNearbyMobs(ServerLevel level, double radius) {
        HashMap<ServerPlayer, List<LivingEntity>> map = new HashMap<ServerPlayer, List<LivingEntity>>();
        List players = level.m_6907_();
        if (players.isEmpty()) {
            return map;
        }
        double maxRadius = radius;
        AABB totalBox = null;
        for (ServerPlayer player : players) {
            AABB playerBox = player.m_20191_().m_82400_(maxRadius);
            if (totalBox == null) {
                totalBox = playerBox;
                continue;
            }
            totalBox = totalBox.m_82367_(playerBox);
        }
        if (totalBox == null) {
            return map;
        }
        List allEntities = level.m_45976_(LivingEntity.class, totalBox);
        for (ServerPlayer player : players) {
            ArrayList<LivingEntity> nearby = new ArrayList<LivingEntity>();
            Vec3 pPos = player.m_20182_();
            for (LivingEntity ent : allEntities) {
                if (ent == player || !(ent.m_20238_(pPos) <= radius * radius)) continue;
                nearby.add(ent);
            }
            map.put(player, nearby);
        }
        return map;
    }

    private static void updateNearbyMobsCache(ServerLevel level) {
        HashMap<ServerPlayer, List> nearbyMobsMap = new HashMap<ServerPlayer, List>();
        for (ServerPlayer player : level.m_6907_()) {
            List nearby = level.m_45976_(LivingEntity.class, player.m_20191_().m_82400_(72.0));
            nearbyMobsMap.put(player, nearby);
        }
        nearbyMobsCache.put(level, nearbyMobsMap);
    }

    private static void cleanupMobCache(ServerLevel level) {
        int tick = level.m_7654_().m_129921_();
        List<CachedMob> cache = mobCache.get(level);
        if (cache != null) {
            cache.removeIf(cm -> {
                LivingEntity e = cm.get();
                return e == null || !e.m_6084_() || tick - cm.lastSeenTick > 100;
            });
        }
    }

    private static void cleanupRecentMobs(ServerLevel level) {
        List<CachedMob> list = recentMobs.get(level);
        if (list == null) {
            return;
        }
        long tick = level.m_7654_().m_129921_();
        list.removeIf(cm -> {
            LivingEntity m = cm.get();
            if (m == null || !m.m_6084_()) {
                return true;
            }
            if ((long)(cm.lastSeenTick + 80) < tick) {
                m.getPersistentData().m_128379_(NBT_INFECTOR_SPAWNED, true);
                return true;
            }
            return false;
        });
    }

    private static void updateRecentMobs(ServerLevel level) {
        List list = recentMobs.computeIfAbsent(level, k -> new ArrayList());
        Map<ServerPlayer, List<LivingEntity>> map = nearbyMobsCache.get(level);
        if (map == null) {
            return;
        }
        int tick = level.m_7654_().m_129921_();
        list.removeIf(cm -> {
            LivingEntity m = cm.get();
            return m == null || !m.m_6084_() || m.m_6095_().m_204039_(SYMBIONT_TAG);
        });
        for (List<LivingEntity> nearList : map.values()) {
            for (LivingEntity mob : nearList) {
                if (mob.m_6095_().m_204039_(SYMBIONT_TAG) || mob.getPersistentData().m_128471_(NBT_INFECTOR_SPAWNED)) continue;
                boolean found = false;
                for (CachedMob cm2 : list) {
                    if (cm2.get() != mob) continue;
                    cm2.lastSeenTick = tick;
                    found = true;
                    break;
                }
                if (found) continue;
                list.add(new CachedMob(mob, tick));
            }
        }
    }

    private static void spawnInfectors(ServerLevel level, double points) {
        List<CachedMob> list = recentMobs.get(level);
        if (list == null || list.isEmpty()) {
            return;
        }
        int attempts = 3;
        int tick = level.m_7654_().m_129921_();
        int maxIndex = list.size();
        for (int t = 0; t < attempts && !list.isEmpty(); ++t) {
            int idx = (int)(Math.random() * (double)maxIndex);
            CachedMob cm = list.get(idx);
            LivingEntity mob = cm.get();
            list.remove(idx);
            maxIndex = list.size();
            if (mob == null || !mob.m_6084_() || mob.m_6095_().m_204039_(SYMBIONT_TAG)) continue;
            double chance = InfectionManager.computeInfectorChance(points);
            int dt = tick - cm.lastSeenTick;
            double factor = Math.min(1.0, (double)dt / 160.0);
            chance *= 1.0 - 0.465 * (1.0 - factor);
            mob.getPersistentData().m_128379_(NBT_INFECTOR_SPAWNED, true);
            if (!(Math.random() < chance) || infectorsSpawnedThisTick >= 3) continue;
            ++infectorsSpawnedThisTick;
            InfectionManager.spawnInfectorNearEntity(level, mob);
        }
        infectorIndex.put(level, 0);
    }

    @SubscribeEvent
    public static void onServerStart(ServerStartingEvent e) {
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        for (ServerLevel level : e.getServer().m_129785_()) {
            Map<ServerPlayer, List<LivingEntity>> nearbyMobsMap;
            if (level.m_6907_().isEmpty()) continue;
            HarmonySymbioticAscensionModVariables.WorldVariables vars = HarmonySymbioticAscensionModVariables.WorldVariables.get((LevelAccessor)level);
            int stage = InfectionManager.getStage(vars.SymbiosisPoints);
            int tick = level.m_7654_().m_129921_();
            int symbionts = 0;
            if (tick % 20 == 0) {
                InfectionManager.updateNearbyMobsCache(level);
                InfectionManager.updateRecentMobs(level);
                currentSymbionts = 0.0;
                nearbyMobsMap = nearbyMobsCache.get(level);
                for (List<LivingEntity> list : nearbyMobsMap.values()) {
                    for (LivingEntity ent : list) {
                        if (!ent.m_6095_().m_204039_(SYMBIONT_TAG)) continue;
                        ++symbionts;
                        currentSymbionts += InfectionManager.computeInfectedBonus(ent);
                    }
                }
                currentSymbionts = Math.min(currentSymbionts, 0.0027);
            }
            if (stage == 0) {
                vars.SymbiosisPoints += currentSymbionts + 2.314814814814815E-4;
                vars.SymbiosisShifterTimer += 1.0;
                if (vars.SymbiosisShifterTimer - Math.random() * 10.0 >= 2400.0) {
                    InfectionManager.spawnInitialShifters(level);
                    vars.SymbiosisShifterTimer = 0.0;
                }
                if (vars.SymbiosisPoints >= 44.44444444444444) {
                    infectorsSpawnedThisTick = 0;
                    InfectionManager.spawnInfectors(level, vars.SymbiosisPoints);
                }
            } else {
                vars.SymbiosisPoints += currentSymbionts + 1.0288065843621399E-4;
            }
            if ((nearbyMobsMap = nearbyMobsCache.get(level)) != null) {
                for (Map.Entry entry : nearbyMobsMap.entrySet()) {
                    ServerPlayer player = (ServerPlayer)entry.getKey();
                    for (LivingEntity sh : (List)entry.getValue()) {
                        if (sh.m_6095_() != InfectionManager.getShifter()) continue;
                        Player nearest = level.m_45930_((Entity)sh, 15.0);
                        InfectionManager.applyLurkerBehavior(level, (Mob)sh, nearest);
                    }
                }
            }
            InfectionManager.cleanupMobCache(level);
            vars.syncData((LevelAccessor)level);
        }
    }

    @SubscribeEvent
    public static void onMobSpawn(MobSpawnEvent.FinalizeSpawn e) {
        Pillager pillager;
        Level level = e.getEntity().m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        Mob ent = e.getEntity();
        if (!(ent instanceof LivingEntity)) {
            return;
        }
        LivingEntity le = (LivingEntity)ent;
        if (ent instanceof Player) {
            return;
        }
        EntityType type = ent.m_6095_();
        if (type.m_204039_(SYMBIONT_TAG) || type.m_204039_(ROBOT_TAG) || type.m_204039_(NO_ENTITIES_TAG) || ent instanceof Player) {
            return;
        }
        int tick = level2.m_7654_().m_129921_();
        CachedMob cm = new CachedMob(le, tick);
        List cache = mobCache.computeIfAbsent(level2, k -> new ArrayList());
        cache.add(cm);
        if (le instanceof Skeleton) {
            Skeleton skeleton = (Skeleton)le;
            if (skeleton.m_21205_().m_41619_()) {
                skeleton.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42411_));
            }
        } else if (le instanceof Pillager && (pillager = (Pillager)le).m_21205_().m_41619_()) {
            pillager.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42717_));
        }
        HarmonySymbioticAscensionModVariables.WorldVariables vars = HarmonySymbioticAscensionModVariables.WorldVariables.get((LevelAccessor)level2);
        int stage = InfectionManager.getStage(vars.SymbiosisPoints);
        double multiplier = InfectionManager.computeSpawnMultiplier(vars.SymbiosisPoints, stage, le, level2);
        MobSpawnType spawnType = e.getSpawnType();
        if (spawnType != MobSpawnType.NATURAL && spawnType != MobSpawnType.CHUNK_GENERATION) {
            return;
        }
        if (Math.random() > multiplier) {
            e.setCanceled(true);
            e.setResult(Event.Result.DENY);
            le.m_6034_(le.m_20185_(), -625.0, le.m_20189_());
            cache.remove(cm);
        }
    }

    @SubscribeEvent
    public static void onMobDeath(LivingDeathEvent e) {
        List<CachedMob> recent;
        Level level = e.getEntity().m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        LivingEntity dead = e.getEntity();
        if (dead instanceof Player) {
            return;
        }
        List<CachedMob> cache = mobCache.get(level2);
        if (cache != null) {
            cache.removeIf(cm -> cm.get() == null || cm.get() == dead);
        }
        if ((recent = recentMobs.get(level2)) != null) {
            recent.removeIf(cm -> cm.get() == null || cm.get() == dead);
        }
    }

    private static int getStage(double points) {
        int i = (int)(points / 100.0);
        return Math.min(2, Math.max(0, i));
    }

    private static double computeInfectedBonus(LivingEntity ent) {
        Mob mob;
        AttributeInstance attr;
        if (ent == null) {
            return 0.0;
        }
        double baseHealthFactor = Math.sqrt((double)ent.m_21233_() / 45.0);
        double healthRatio = ent.m_21223_() / ent.m_21233_();
        healthRatio = Math.max(0.0, Math.min(1.0, healthRatio));
        double healthMultiplier = Math.pow(healthRatio, 3.0);
        double healthFactor = baseHealthFactor * healthMultiplier;
        double attackDamage = 0.0;
        if (ent instanceof Mob && (attr = (mob = (Mob)ent).m_21051_(Attributes.f_22281_)) != null) {
            attackDamage = attr.m_22135_();
        }
        double damageFactor = attackDamage > 0.0 ? Math.sqrt(attackDamage / 27.0) : 0.0;
        double bonus = 2.0E-5 * (0.001 + healthFactor + damageFactor);
        return Math.min(bonus, 0.001);
    }

    private static double computeSpawnMultiplier(double points, int stage, LivingEntity ent, ServerLevel level) {
        boolean infectorsPresent;
        boolean bl = infectorsPresent = InfectionManager.hasInfector(level) && points >= 30.0;
        if (stage == 0 && !infectorsPresent) {
            return 1.0;
        }
        if (stage == 0 && infectorsPresent) {
            double effectivePoints = Math.max(points - 35.0, 0.0);
            double norm = effectivePoints / 65.0;
            double suppression = 1.0 - (0.36 + 0.64 * (1.0 - norm));
            double typeFactor = ent instanceof Animal ? 1.0 : (ent instanceof WaterAnimal ? 0.2 : (ent instanceof AmbientCreature ? 1.0E-6 : (ent instanceof Monster ? (ent.m_20186_() < 50.0 ? 0.75 : 0.95) : 1.0)));
            double mult = suppression * typeFactor;
            return Math.max(0.36, Math.min(1.0, mult));
        }
        if (points >= 107.0) {
            return 0.0;
        }
        double stageSup = STAGE_SUPPRESSION[Math.min(stage, STAGE_SUPPRESSION.length - 1)];
        double norm = points / 300.0;
        double progSup = Math.sqrt(norm) * 0.9;
        double typeFactor = ent instanceof Animal ? 0.007 : (ent instanceof WaterAnimal ? 1.0E-4 : (ent instanceof Monster ? 0.009 : (ent instanceof AmbientCreature ? 0.0 : 0.012)));
        double totalSup = Math.min(0.995, stageSup + progSup * 0.4);
        double mult = (0.83 - totalSup) * typeFactor;
        return Math.max(0.01, Math.min(1.0, Math.abs(mult)));
    }

    private static boolean hasInfector(ServerLevel level) {
        HarmonySymbioticAscensionModVariables.WorldVariables vars = HarmonySymbioticAscensionModVariables.WorldVariables.get((LevelAccessor)level);
        return vars.AgressiveInfectors;
    }

    private static double countNearbyInfected(ServerLevel lvl) {
        HashSet<UUID> counted = new HashSet<UUID>();
        double totalBonus = 0.0;
        for (ServerPlayer player : lvl.m_6907_()) {
            List cache = mobCache.getOrDefault(lvl, Collections.emptyList());
            for (CachedMob cm : cache) {
                LivingEntity e = cm.get();
                if (e == null || !e.m_6084_() || !e.m_6095_().m_204039_(SYMBIONT_TAG) || !((double)e.m_20270_((Entity)player) <= 72.0) || !counted.add(e.m_20148_())) continue;
                totalBonus += InfectionManager.computeInfectedBonus(e);
            }
        }
        return Math.min(totalBonus, 0.0024);
    }

    private static void spawnInitialShifters(ServerLevel lvl) {
        int MAX_SHIFTERS_PER_TICK = 6;
        int SHIFTERS_PER_PLAYER = 2;
        int MIN_DIST = 5;
        int MAX_DIST = 32;
        int spawned = 0;
        block0: for (ServerPlayer player : lvl.m_6907_()) {
            if (spawned >= 6) break;
            double px = player.m_20185_();
            double py = player.m_20186_();
            double pz = player.m_20189_();
            int amount = 1 + (int)(Math.random() * 2.0);
            amount = Math.min(amount, 6 - spawned);
            for (int i = 0; i < amount; ++i) {
                double threshold;
                BlockPos base;
                boolean useBehind;
                boolean bl = useBehind = Math.random() < 0.15;
                if (useBehind) {
                    base = InfectionManager.getBehindPlayerPosition(player, 5, 32);
                } else {
                    double angle = Math.random() * Math.PI * 2.0;
                    double dist = 5.0 + Math.random() * 27.0;
                    double x = px + Math.cos(angle) * dist;
                    double z = pz + Math.sin(angle) * dist;
                    base = BlockPos.m_274561_((double)x, (double)py, (double)z);
                }
                BlockPos spawnPos = InfectionManager.findViableSpawn(lvl, base);
                if (spawnPos == null) continue;
                double score = 0.0;
                int light = lvl.m_46803_(spawnPos);
                if (light <= 1) {
                    score += 2.1;
                } else if (light <= 3) {
                    score += 2.3;
                } else if (light <= 6) {
                    score += 1.7;
                } else if (light <= 9) {
                    score += 0.6;
                }
                if (InfectionManager.hasWallNearby(lvl, spawnPos)) {
                    score += 2.0;
                }
                score += InfectionManager.computeNaturalShelterFactor(lvl, spawnPos);
                if (!InfectionManager.checkLineOfSight(player, spawnPos, lvl)) {
                    score += 3.6;
                }
                if ((score += Math.random() * 1.5) < (threshold = 4.1)) continue;
                Entity ent = InfectionManager.getShifter().m_20615_((Level)lvl);
                if (ent instanceof LivingEntity) {
                    LivingEntity le = (LivingEntity)ent;
                    le.m_6034_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5);
                    if (!lvl.m_45786_((Entity)le) || !lvl.m_45784_((Entity)le)) continue;
                    long nearbyShifters = lvl.m_142425_(InfectionManager.getShifter(), le.m_20191_().m_82400_(16.0), e -> e instanceof ShifterEntity).size();
                    if (nearbyShifters >= 1L) {
                        return;
                    }
                    ShifterOnInitialEntitySpawnProcedure.execute((Entity)le);
                    lvl.m_7967_((Entity)le);
                    ++spawned;
                }
                if (spawned >= 6) continue block0;
            }
        }
    }

    private static double computeNaturalShelterFactor(ServerLevel lvl, BlockPos pos) {
        int nearbySolid = 0;
        int nearbyLogs = 0;
        int nearbyLeaves = 0;
        int airBelow = 0;
        BlockPos.MutableBlockPos m = new BlockPos.MutableBlockPos();
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                m.m_122178_(pos.m_123341_() + dx, pos.m_123342_(), pos.m_123343_() + dz);
                BlockState state = lvl.m_8055_((BlockPos)m);
                if (state.m_60795_()) {
                    BlockPos b1 = m.m_6625_(1);
                    BlockPos b2 = m.m_6625_(2);
                    BlockPos b3 = m.m_6625_(3);
                    if (!lvl.m_8055_(b1).m_60795_() || !lvl.m_8055_(b2).m_60795_() || !lvl.m_8055_(b3).m_60795_()) continue;
                    ++airBelow;
                    continue;
                }
                if (state.m_280296_()) {
                    ++nearbySolid;
                }
                if (state.m_204336_(BlockTags.f_13106_)) {
                    ++nearbyLogs;
                }
                if (!state.m_204336_(BlockTags.f_13035_)) continue;
                ++nearbyLeaves;
            }
        }
        double factor = 1.0;
        if (airBelow > 4) {
            factor += 0.4;
        }
        if (nearbyLogs > 2) {
            factor += 0.3;
        }
        if (nearbyLeaves > 4) {
            factor += 0.2;
        }
        if (nearbySolid > 20) {
            factor += 0.1;
        }
        return Math.min(factor, 1.75);
    }

    private static BlockPos findViableSpawn(ServerLevel lvl, BlockPos base) {
        for (int dy = -3; dy <= 3; ++dy) {
            BlockPos pos = base.m_7918_(0, dy, 0);
            if (!InfectionManager.isValidSpawn(lvl, pos)) continue;
            return pos;
        }
        return null;
    }

    private static boolean checkLineOfSight(ServerPlayer player, BlockPos pos, ServerLevel lvl) {
        Vec3 eye = player.m_146892_();
        Vec3 target = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5);
        BlockHitResult result = lvl.m_45547_(new ClipContext(eye, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        return result.m_82425_().equals((Object)pos);
    }

    private static boolean hasWallNearby(ServerLevel lvl, BlockPos pos) {
        int[][] offsets;
        for (int[] o : offsets = new int[][]{{1, 0}, {-1, 0}, {0, 1}, {0, -1}}) {
            BlockPos check = pos.m_7918_(o[0], 0, o[1]);
            if (lvl.m_8055_(check).m_60795_() || lvl.m_8055_(check).m_60812_((BlockGetter)lvl, check).m_83281_()) continue;
            return true;
        }
        return false;
    }

    private static BlockPos getBehindPlayerPosition(ServerPlayer player, int minDist, int maxDist) {
        Vec3 look = player.m_20154_().m_82541_();
        Vec3 behind = look.m_82490_(-1.0);
        double dist = (double)minDist + Math.random() * (double)(maxDist - minDist);
        Vec3 pos = player.m_20182_().m_82549_(behind.m_82490_(dist));
        return BlockPos.m_274561_((double)pos.f_82479_, (double)pos.f_82480_, (double)pos.f_82481_);
    }

    private static void spawnInfectorNearEntity(ServerLevel level, LivingEntity target) {
        Entity ent;
        long nearbyInfectors = level.m_143280_(InfectionManager.getInfector(), e -> e.m_20280_((Entity)target) < 16.0).size();
        if (nearbyInfectors >= 2L) {
            return;
        }
        double x = target.m_20185_() + (Math.random() - 0.5) * 2.5;
        double z = target.m_20189_() + (Math.random() - 0.5) * 2.5;
        int baseY = (int)target.m_20186_();
        BlockPos original = new BlockPos((int)x, baseY, (int)z);
        BlockPos pos = original;
        if (!InfectionManager.isValidSpawn(level, pos)) {
            BlockPos tryPos;
            int dy;
            boolean found = false;
            for (dy = 1; dy <= 6; ++dy) {
                tryPos = original.m_6630_(dy);
                if (!InfectionManager.isValidSpawn(level, tryPos)) continue;
                pos = tryPos;
                found = true;
                break;
            }
            if (!found) {
                for (dy = 1; dy <= 6; ++dy) {
                    tryPos = original.m_6625_(dy);
                    if (!InfectionManager.isValidSpawn(level, tryPos)) continue;
                    pos = tryPos;
                    found = true;
                    break;
                }
            }
            if (!found) {
                return;
            }
        }
        if ((ent = InfectionManager.getInfector().m_20615_((Level)level)) instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)ent;
            le.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            if (!level.m_45786_((Entity)le)) {
                return;
            }
            if (!level.m_45784_((Entity)le)) {
                return;
            }
            InfectorOnIntinalSpawnProcedure.execute((LevelAccessor)level, (Entity)le);
            level.m_7967_((Entity)le);
        }
    }

    private static boolean isValidSpawn(ServerLevel level, BlockPos pos) {
        if (!level.m_8055_(pos).m_60812_((BlockGetter)level, pos).m_83281_()) {
            return false;
        }
        if (level.m_8055_(pos.m_7495_()).m_60812_((BlockGetter)level, pos.m_7495_()).m_83281_()) {
            return false;
        }
        if (!level.m_6425_(pos).m_76178_()) {
            return false;
        }
        if (level.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13035_)) {
            return false;
        }
        return !level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50083_) && !level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50450_) && !level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50683_) && !level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50684_) && !level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50128_) && !level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50685_);
    }

    private static double computeInfectorChance(double points) {
        double basePoints = 37.0;
        double maxPoints = 100.0;
        double baseChance = 0.002;
        double maxChance = 0.2715;
        if (points <= basePoints) {
            return 0.0;
        }
        double t = (points - basePoints) / (maxPoints - basePoints);
        double chance = maxChance / (1.0 + Math.exp(-10.0 * (t - 0.5)));
        return Math.min(chance, maxChance);
    }

    private static void applyLurkerBehavior(ServerLevel lvl, Mob shifter, Player nearest) {
        BlockPos target;
        if (shifter == null || nearest == null) {
            return;
        }
        CompoundTag data = shifter.getPersistentData();
        double dist = shifter.m_20270_((Entity)nearest);
        if (dist < 5.0) {
            Vec3 dir = shifter.m_20182_().m_82546_(nearest.m_20182_()).m_82541_().m_82490_(4.0);
            shifter.m_21573_().m_26519_(shifter.m_20185_() + dir.f_82479_, shifter.m_20186_(), shifter.m_20189_() + dir.f_82481_, 0.78);
            data.m_128405_("LurkerCooldown", 60);
            data.m_128473_("LurkerTarget");
            return;
        }
        int cooldown = data.m_128451_("LurkerCooldown");
        if (cooldown > 0) {
            data.m_128405_("LurkerCooldown", cooldown - 1);
            return;
        }
        int age = data.m_128451_("LurkerTargetAge");
        BlockPos blockPos = target = data.m_128441_("LurkerTarget") ? NbtUtils.m_129239_((CompoundTag)data.m_128469_("LurkerTarget")) : null;
        if (target == null || age > 360) {
            target = InfectionManager.pickLurkerTarget(shifter, lvl);
            if (target != null) {
                data.m_128365_("LurkerTarget", (Tag)NbtUtils.m_129224_((BlockPos)target));
            }
            data.m_128405_("LurkerTargetAge", 0);
        } else {
            data.m_128405_("LurkerTargetAge", age + 1);
        }
        if (target != null) {
            int skyCurrent = lvl.m_45517_(LightLayer.SKY, shifter.m_20183_());
            int skyTarget = lvl.m_45517_(LightLayer.SKY, target);
            double darkCurrent = (double)(15 - skyCurrent) / 15.0;
            double darkTarget = (double)(15 - skyTarget) / 15.0;
            double darknessDelta = darkTarget - darkCurrent;
            double speed = 0.4;
            if (darknessDelta > 0.0) {
                speed += Math.min(0.4, darknessDelta * 0.4);
            }
            if (darkCurrent > 0.75) {
                speed -= 0.17;
            }
            speed = Math.max(0.4, Math.min(0.75, speed));
            shifter.m_21573_().m_26519_((double)target.m_123341_() + 0.5, (double)target.m_123342_(), (double)target.m_123343_() + 0.5, speed);
        }
    }

    private static BlockPos pickLurkerTarget(Mob shifter, ServerLevel lvl) {
        BlockPos base = shifter.m_20183_();
        BlockPos best = null;
        double bestScore = -9999.0;
        for (int i = 0; i < 30; ++i) {
            int dz;
            int dx = lvl.m_213780_().m_188503_(17) - 8;
            BlockPos pos = base.m_7918_(dx, 0, dz = lvl.m_213780_().m_188503_(17) - 8);
            if (!lvl.m_46749_(pos) || !lvl.m_8055_(pos).m_60795_() || !lvl.m_8055_(pos.m_7494_()).m_60795_()) continue;
            int sky = lvl.m_45517_(LightLayer.SKY, pos);
            double shadow = (double)(15 - sky) / 15.0;
            int solid = 0;
            for (Direction d : Direction.Plane.HORIZONTAL) {
                if (!lvl.m_8055_(pos.m_121945_(d)).m_60804_((BlockGetter)lvl, pos)) continue;
                ++solid;
            }
            double walls = (double)solid / 4.0;
            double score = shadow * 1.5 + walls * 1.2;
            if (!(score > bestScore)) continue;
            bestScore = score;
            best = pos;
        }
        return best != null ? best : base;
    }

    public static void addPoints(ServerLevel lvl, double v) {
        HarmonySymbioticAscensionModVariables.WorldVariables vars = HarmonySymbioticAscensionModVariables.WorldVariables.get((LevelAccessor)lvl);
        vars.SymbiosisPoints += Math.abs(v);
        vars.syncData((LevelAccessor)lvl);
    }

    public static void setPoints(ServerLevel lvl, double v) {
        HarmonySymbioticAscensionModVariables.WorldVariables vars = HarmonySymbioticAscensionModVariables.WorldVariables.get((LevelAccessor)lvl);
        vars.SymbiosisPoints = Math.abs(v);
        vars.syncData((LevelAccessor)lvl);
    }

    public static InfectionStatus getStatus(ServerLevel lvl) {
        HarmonySymbioticAscensionModVariables.WorldVariables vars = HarmonySymbioticAscensionModVariables.WorldVariables.get((LevelAccessor)lvl);
        return new InfectionStatus(vars.SymbiosisPoints, InfectionManager.getStage(vars.SymbiosisPoints));
    }

    public static int getSymbiontCount(LevelAccessor lvl) {
        int count = 0;
        Map<ServerPlayer, List<LivingEntity>> map = nearbyMobsCache.get(lvl);
        if (map == null) {
            return 0;
        }
        for (List<LivingEntity> list : map.values()) {
            for (LivingEntity e : list) {
                if (e == null || !e.m_6084_() || !e.m_6095_().m_204039_(SYMBIONT_TAG)) continue;
                ++count;
            }
        }
        return count;
    }

    public static int getCurrentSymbiontBonusInt(LevelAccessor lvl) {
        double bonus = 0.0;
        Map<ServerPlayer, List<LivingEntity>> map = nearbyMobsCache.get(lvl);
        if (map == null) {
            return 0;
        }
        for (List<LivingEntity> list : map.values()) {
            for (LivingEntity e : list) {
                if (e == null || !e.m_6084_() || !e.m_6095_().m_204039_(SYMBIONT_TAG)) continue;
                bonus += InfectionManager.computeInfectedBonus(e);
            }
        }
        bonus = Math.min(bonus, 0.0027);
        return (int)(bonus * 10000.0);
    }

    private static class CachedMob {
        final WeakReference<LivingEntity> ref;
        int lastSeenTick;

        CachedMob(LivingEntity mob, int tick) {
            this.ref = new WeakReference<LivingEntity>(mob);
            this.lastSeenTick = tick;
        }

        LivingEntity get() {
            return (LivingEntity)this.ref.get();
        }
    }

    public static class InfectionStatus {
        public final double points;
        public final int stage;

        public InfectionStatus(double p, int s) {
            this.points = p;
            this.stage = s;
        }
    }
}

