/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.harmonysymbioticascension.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BloodParticle
extends TextureSheetParticle {
    private float initialBrightness = 0.7f;
    private final SpriteSet spriteSet;
    private float angularVelocity;
    private float angularAcceleration;

    public static BloodParticleProvider provider(SpriteSet spriteSet) {
        return new BloodParticleProvider(spriteSet);
    }

    protected BloodParticle(ClientLevel world, double x, double y, double z, double vx, double vy, double vz, SpriteSet spriteSet) {
        super(world, x, y, z);
        this.spriteSet = spriteSet;
        this.m_107250_(0.2f, 0.2f);
        this.f_107663_ *= 2.0f;
        this.f_107225_ = Math.max(1, 38 + (this.f_107223_.m_188503_(104) - 52));
        this.f_107226_ = -0.0125f;
        this.f_107219_ = true;
        this.f_107215_ = vx * 0.1;
        this.f_107216_ = vy * 0.1;
        this.f_107217_ = vz * 0.1;
        this.angularVelocity = 0.005f;
        this.angularAcceleration = 0.0f;
        this.m_108335_(spriteSet);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5989_() {
        float lifeRatio = (float)this.f_107224_ / (float)this.f_107225_;
        float alpha = 1.0f - lifeRatio * 0.8725f;
        this.m_107271_(alpha);
        super.m_5989_();
        this.f_107204_ = this.f_107231_;
        this.f_107231_ += this.angularVelocity;
        this.angularVelocity += this.angularAcceleration;
    }

    public int m_6355_(float partialTick) {
        float lifeRatio = (float)this.f_107224_ / (float)this.f_107225_;
        int base = 0xF000F0;
        float brightnessFactor = this.initialBrightness * (1.0f - lifeRatio * 0.7525f);
        int sky = (int)(15.0f * brightnessFactor);
        int block = (int)(15.0f * brightnessFactor);
        return sky << 20 | block << 4;
    }

    public static class BloodParticleProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public BloodParticleProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new BloodParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

