/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.harmonysymbioticascension.procedures;

import java.util.EnumSet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;

public class CustomDoorBreakerGoalProcedure
extends Goal {
    private final Mob mob;
    private BlockPos targetBlock;
    private int progress;
    private int tickCounter;
    private int breakerId;
    private int ticksPerStage;

    public CustomDoorBreakerGoalProcedure(Mob mob) {
        this.mob = mob;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.breakerId = new Random().nextInt(100000) + mob.m_19879_();
    }

    public boolean m_8036_() {
        if (!this.mob.getPersistentData().m_128471_("CanBreakDoors")) {
            return false;
        }
        BlockPos mobPos = this.mob.m_20183_();
        Level level = this.mob.m_9236_();
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)mobPos.m_7918_(-1, -1, -1), (BlockPos)mobPos.m_7918_(1, 2, 1))) {
            double distance;
            BlockState state = level.m_8055_(pos);
            Block block = state.m_60734_();
            if (!this.isBreakableBlock(block) || !((distance = this.mob.m_20182_().m_82531_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5)) <= 2.25)) continue;
            this.targetBlock = pos.m_7949_();
            this.calculateBreakSpeed(state, level, pos);
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        return this.targetBlock != null && !this.mob.m_9236_().m_8055_(this.targetBlock).m_60795_() && this.isBreakableBlock(this.mob.m_9236_().m_8055_(this.targetBlock).m_60734_());
    }

    public void m_8056_() {
        this.progress = 0;
        this.tickCounter = 0;
    }

    public void m_8041_() {
        Level level = this.mob.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.targetBlock != null) {
                serverLevel.m_6801_(this.breakerId, this.targetBlock, -1);
            }
        }
        this.targetBlock = null;
    }

    public void m_8037_() {
        if (this.targetBlock == null) {
            return;
        }
        this.mob.m_21573_().m_26573_();
        ++this.tickCounter;
        Level level = this.mob.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.tickCounter % this.ticksPerStage == 0) {
            ++this.progress;
            BlockState state = this.mob.m_9236_().m_8055_(this.targetBlock);
            if (this.isBreakableBlock(state.m_60734_()) && this.progress > 0) {
                int crackStage = Math.min(this.progress * 3, 9);
                serverLevel.m_6801_(this.breakerId, this.targetBlock, crackStage);
                this.mob.m_9236_().m_46796_(2001, this.targetBlock, Block.m_49956_((BlockState)state));
                this.mob.getPersistentData().m_128405_("DoorFrustration", 0);
            }
            if (this.progress >= 3) {
                serverLevel.m_6801_(this.breakerId, this.targetBlock, -1);
                serverLevel.m_46953_(this.targetBlock, true, (Entity)this.mob);
                this.mob.m_9236_().m_5594_(null, this.targetBlock, SoundEvents.f_12601_, SoundSource.HOSTILE, 1.0f, 1.0f);
                this.m_8041_();
                return;
            }
            this.mob.m_9236_().m_5594_(null, this.targetBlock, SoundEvents.f_12599_, SoundSource.HOSTILE, 0.8f, 1.0f);
        }
    }

    private boolean isBreakableBlock(Block block) {
        return block instanceof DoorBlock || block instanceof TrapDoorBlock || block instanceof FenceGateBlock || block.m_49966_().m_204336_(BlockTags.f_13103_) || block.m_49966_().m_204336_(BlockTags.f_13055_) || block.m_49966_().m_204336_(BlockTags.f_13036_);
    }

    private void calculateBreakSpeed(BlockState state, Level level, BlockPos pos) {
        float hardness = state.m_60800_((BlockGetter)level, pos);
        if (hardness <= 0.0f) {
            hardness = 1.0f;
        }
        this.ticksPerStage = (int)Math.min(3.0f * hardness, 120.0f);
        this.ticksPerStage = Math.max(this.ticksPerStage, 7);
    }
}

