/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.harmonysymbioticascension.procedures;

import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.mcreator.harmonysymbioticascension.entity.InfectorEntity;
import net.mcreator.harmonysymbioticascension.network.HarmonySymbioticAscensionModVariables;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class CustomInfectorAttackGoalProcedure
extends TargetGoal {
    private static final TagKey<EntityType<?>> SYMBIONT_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("harmony:symbionts"));
    private static final TagKey<EntityType<?>> ROBOT_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("btw:empire"));
    private static final TagKey<EntityType<?>> NO_ENTITIES_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("minecraft:no_entities"));
    private final Mob infector;
    private final RandomSource rand = RandomSource.m_216327_();
    private final double personalitySeed;
    private LivingEntity target;
    private static final String P_PERSONALITY = "infector_personality_seed";
    private static final String P_MOOD = "infector_mood_level";
    private static final String P_TRAITS = "infector_traits_bitmask";

    public CustomInfectorAttackGoalProcedure(Mob mob, int distance) {
        super(mob, true, true);
        this.infector = mob;
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        UUID id = mob.m_20148_();
        this.personalitySeed = id == null ? this.rand.m_188500_() : (double)id.hashCode() * 1.0E-4;
        this.ensurePersonalityInitialized();
    }

    private void ensurePersonalityInitialized() {
        try {
            CompoundTag data = this.infector.getPersistentData();
            if (!data.m_128441_(P_PERSONALITY)) {
                data.m_128347_(P_PERSONALITY, this.personalitySeed);
                data.m_128347_(P_MOOD, (this.rand.m_188500_() - 0.5) * 0.5);
                int mask = 0;
                if (this.rand.m_188500_() < 0.4) {
                    mask |= 1;
                }
                if (this.rand.m_188500_() < 0.35) {
                    mask |= 2;
                }
                if (this.rand.m_188500_() < 0.25) {
                    mask |= 4;
                }
                data.m_128405_(P_TRAITS, mask);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean m_8036_() {
        Level world = this.infector.m_9236_();
        double points = HarmonySymbioticAscensionModVariables.WorldVariables.get((LevelAccessor)world).SymbiosisPoints;
        double chaos = this.computeChaos(points);
        if (this.rand.m_188500_() < 0.05) {
            this.doMoodContagion();
        }
        double seekProb = 0.15 + chaos * 0.7;
        int traits = this.getTraits();
        if ((traits & 2) != 0) {
            seekProb += 0.12;
        }
        if ((traits & 4) != 0) {
            seekProb -= 0.1;
        }
        seekProb = Math.max(0.0, Math.min(1.0, seekProb));
        if (this.rand.m_188500_() >= seekProb) {
            return false;
        }
        List list = this.infector.m_9236_().m_6443_(LivingEntity.class, this.infector.m_20191_().m_82400_(this.m_7623_()), e -> e != null && this.isValidType((LivingEntity)e) && this.infector.m_142582_((Entity)e));
        if (list.isEmpty()) {
            return false;
        }
        list.sort((a, b) -> Double.compare(a.m_20280_((Entity)this.infector), b.m_20280_((Entity)this.infector)));
        for (LivingEntity e2 : list) {
            if (!this.canAttack(e2)) continue;
            this.target = e2;
            return true;
        }
        return false;
    }

    public void m_8056_() {
        if (this.target == null || !this.isValidType(this.target)) {
            this.m_8041_();
            return;
        }
        this.infector.m_6710_(this.target);
        super.m_8056_();
    }

    public boolean m_8045_() {
        if (this.target == null || !this.target.m_6084_()) {
            return false;
        }
        if (!this.isValidType(this.target)) {
            return false;
        }
        if (this.rand.m_188500_() < 0.05 && this.getMood() < -0.6) {
            return false;
        }
        return this.infector.m_20280_((Entity)this.target) <= this.m_7623_() * this.m_7623_();
    }

    public void m_8041_() {
        super.m_8041_();
        this.target = null;
        this.infector.m_6710_(null);
    }

    public boolean canAttack(LivingEntity target) {
        boolean willAttack;
        if (target == null || target == this.infector) {
            return false;
        }
        if (!this.isValidType(target)) {
            return false;
        }
        Level world = this.infector.m_9236_();
        double points = HarmonySymbioticAscensionModVariables.WorldVariables.get((LevelAccessor)world).SymbiosisPoints;
        double threshold = this.sigmoid((points - 35.0) * 0.15);
        if (threshold < this.rand.m_188500_() * 0.3) {
            return false;
        }
        double character = (this.personalitySeed + (double)this.getTraits() * 0.17) % 1.0;
        double base = threshold * (0.25 + character * 0.35);
        double t = (double)this.infector.f_19797_ * 0.03 + this.personalitySeed * 17.0;
        double noise = Math.sin(t) * 0.2 + Math.cos(t * 1.7) * 0.1;
        base += noise;
        double mood = this.getMood();
        base += mood * 0.3;
        int traits = this.getTraits();
        if ((traits & 1) != 0) {
            base += 0.12;
        }
        if ((traits & 2) != 0) {
            base += 0.18;
        }
        if ((traits & 4) != 0) {
            base -= 0.25;
        }
        base += (this.rand.m_188500_() - 0.5) * 0.4;
        base = Math.max(0.0, Math.min(1.0, base));
        if (target instanceof Player) {
            base *= Math.max(points * 0.01 - 0.185, 0.0);
        } else if (points < 50.0) {
            base *= 0.3 + points * 0.0013;
        }
        boolean bl = willAttack = this.rand.m_188500_() < (base *= points / 100.0);
        if (!willAttack && (traits & 1) != 0 && this.rand.m_188500_() < 0.15 + Math.abs(mood) * 0.3) {
            this.performFakeAttack(target);
        }
        if ((traits & 4) != 0 && this.rand.m_188500_() < 0.12 + (1.0 - threshold) * 0.3) {
            this.performPsychoticFlee();
        }
        LivingEntity current = this.f_26135_.m_5448_();
        if ((traits & 2) != 0 && current != null && current.equals((Object)target) && this.rand.m_188500_() < 0.6) {
            return true;
        }
        return willAttack;
    }

    private boolean isValidType(LivingEntity e) {
        Player p;
        if (e.m_6095_().m_204039_(SYMBIONT_TAG)) {
            return false;
        }
        if (e.m_6095_().m_204039_(NO_ENTITIES_TAG)) {
            return false;
        }
        if (e.m_6095_().m_204039_(ROBOT_TAG)) {
            return false;
        }
        return !(e instanceof Player) || !(p = (Player)e).m_7500_() && !p.m_5833_();
    }

    protected double m_7623_() {
        return this.f_26135_.m_21133_(Attributes.f_22277_);
    }

    private void performFakeAttack(LivingEntity target) {
        List nearby;
        if (this.rand.m_188500_() < 0.35 && !(nearby = this.infector.m_9236_().m_6443_(LivingEntity.class, this.infector.m_20191_().m_82400_(6.0), e -> e != null && e != this.infector)).isEmpty()) {
            this.infector.m_6710_((LivingEntity)nearby.get(this.rand.m_188503_(nearby.size())));
        }
    }

    private void performPsychoticFlee() {
        this.infector.m_6710_(null);
        this.adjustMood(-0.2);
    }

    private int getTraits() {
        try {
            return this.infector.getPersistentData().m_128451_(P_TRAITS);
        }
        catch (Throwable t) {
            return 0;
        }
    }

    private double getMood() {
        try {
            return this.infector.getPersistentData().m_128459_(P_MOOD);
        }
        catch (Throwable t) {
            return 0.0;
        }
    }

    private void adjustMood(double delta) {
        try {
            double m = this.getMood() + delta;
            this.infector.getPersistentData().m_128347_(P_MOOD, Math.max(-1.0, Math.min(1.0, m)));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void doMoodContagion() {
        List nearby = this.infector.m_9236_().m_6443_(LivingEntity.class, this.infector.m_20191_().m_82400_(8.0), e -> e != null && e != this.infector);
        double total = 0.0;
        int count = 0;
        for (LivingEntity e2 : nearby) {
            if (!(e2 instanceof InfectorEntity)) continue;
            try {
                total += e2.getPersistentData().m_128459_(P_MOOD);
                ++count;
            }
            catch (Throwable throwable) {}
        }
        if (count == 0) {
            return;
        }
        double avg = total / (double)count;
        double self = this.getMood();
        double newMood = self + (avg - self) * 0.18 + (this.rand.m_188500_() - 0.5) * 0.06;
        this.infector.getPersistentData().m_128347_(P_MOOD, Math.max(-1.0, Math.min(1.0, newMood)));
    }

    private double computeChaos(double points) {
        double t = (double)this.infector.f_19797_ * 0.02;
        double seed = this.infector.getPersistentData().m_128441_(P_PERSONALITY) ? this.infector.getPersistentData().m_128459_(P_PERSONALITY) : this.personalitySeed;
        double noise = Math.sin(t + seed) * 0.45 + Math.cos(t * 0.7 + seed * 1.3) * 0.25;
        double base = this.sigmoid((points - 20.0) * 0.03);
        double mood = this.getMood();
        int traits = this.getTraits();
        double traitBoost = 0.0;
        if ((traits & 1) != 0) {
            traitBoost += 0.06;
        }
        if ((traits & 2) != 0) {
            traitBoost += 0.08;
        }
        if ((traits & 4) != 0) {
            traitBoost += 0.02;
        }
        double rnd = (this.rand.m_188500_() - 0.5) * 0.28;
        double value = base + noise * 0.6 + mood * 0.18 + traitBoost + rnd;
        return Math.max(0.0, Math.min(1.0, (value + 1.2) / 2.4));
    }

    private double sigmoid(double x) {
        return 1.0 / (1.0 + Math.exp(-x));
    }
}

