/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.harmonysymbioticascension.procedures;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class FenceRemoverProcedure {
    private static final int MAX_DISTANCE = 4;

    public static void removeConnectedFences(LevelAccessor world, BlockPos pos) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        FenceRemoverProcedure.removeRecursive(world, pos, visited);
    }

    private static void removeRecursive(LevelAccessor world, BlockPos pos, Set<BlockPos> visited) {
        BlockPos[] neighbors;
        if (visited.contains(pos)) {
            return;
        }
        visited.add(pos);
        BlockState state = world.m_8055_(pos);
        if (!state.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("minecraft:fences_and_walls")))) {
            return;
        }
        world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        BlockPos above = pos.m_7494_();
        BlockState aboveState = world.m_8055_(above);
        if (!aboveState.m_60795_() && !aboveState.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("minecraft:fences_and_walls")))) {
            FenceRemoverProcedure.makeFallingConnected(world, above, pos, 0);
        }
        for (BlockPos neighbor : neighbors = new BlockPos[]{pos.m_122012_(), pos.m_122019_(), pos.m_122029_(), pos.m_122024_(), pos.m_7494_(), pos.m_7495_()}) {
            FenceRemoverProcedure.removeRecursive(world, neighbor, visited);
        }
    }

    private static void makeFallingConnected(LevelAccessor world, BlockPos startPos, BlockPos origin, int depth) {
        if (depth > 4) {
            return;
        }
        HashSet<BlockPos> processed = new HashSet<BlockPos>();
        LinkedList<BlockPos> toCheck = new LinkedList<BlockPos>();
        toCheck.add(startPos);
        while (!toCheck.isEmpty()) {
            BlockPos[] neighbors;
            BlockState state;
            BlockPos pos = (BlockPos)toCheck.poll();
            if (processed.contains(pos)) continue;
            processed.add(pos);
            if (pos.m_123333_((Vec3i)origin) > 4 || (state = world.m_8055_(pos)).m_60795_() || state.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("minecraft:fences_and_walls")))) continue;
            BlockPos below = pos.m_7495_();
            BlockState belowState = world.m_8055_(below);
            if (FenceRemoverProcedure.canFallOn(belowState)) {
                FenceRemoverProcedure.spawnFallingBlock(world, pos, state);
            }
            for (BlockPos neighbor : neighbors = new BlockPos[]{pos.m_122012_(), pos.m_122019_(), pos.m_122029_(), pos.m_122024_(), pos.m_7494_(), pos.m_7495_()}) {
                BlockState nState;
                if (neighbor.m_123333_((Vec3i)origin) > 4 || (nState = world.m_8055_(neighbor)).m_60795_() || nState.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("minecraft:fences_and_walls")))) continue;
                toCheck.add(neighbor);
            }
        }
    }

    private static boolean canFallOn(BlockState belowState) {
        return belowState.m_60795_() || belowState.m_204336_(BlockTags.f_13041_) || belowState.m_204336_(BlockTags.f_278394_) || belowState.m_204336_(BlockTags.f_13073_) || belowState.m_204336_(BlockTags.f_13104_) || belowState.m_204336_(BlockTags.f_13057_) || belowState.m_60713_(Blocks.f_50125_) || belowState.m_60713_(Blocks.f_50359_) || belowState.m_60713_(Blocks.f_50034_) || belowState.m_60713_(Blocks.f_50035_) || belowState.m_60713_(Blocks.f_50360_) || belowState.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("harmony:symbiontic_plants")));
    }

    private static void spawnFallingBlock(LevelAccessor world, BlockPos pos, BlockState state) {
        if (world instanceof ServerLevel) {
            ServerLevel _level = (ServerLevel)world;
            FallingBlockEntity.m_201971_((Level)_level, (BlockPos)pos, (BlockState)state);
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        }
    }
}

