/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.harmonysymbioticascension.procedures;

import java.util.Map;
import net.mcreator.harmonysymbioticascension.init.HarmonySymbioticAscensionModBlocks;
import net.mcreator.harmonysymbioticascension.init.HarmonySymbioticAscensionModItems;
import net.mcreator.harmonysymbioticascension.procedures.FenceRemoverProcedure;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class PrimordialCoreOnTickUpdateProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z) {
        BlockPos pos = new BlockPos((int)x, (int)y, (int)z);
        BlockEntity be = world.m_7702_(pos);
        if (be == null) {
            return;
        }
        CompoundTag data = be.getPersistentData();
        int timer = data.m_128451_("timer");
        int radius = data.m_128451_("radius");
        int maxRadius = data.m_128451_("maxRadius");
        boolean expanding = data.m_128471_("expanding");
        if (!expanding) {
            if (++timer >= 2400) {
                timer = 0;
                expanding = true;
                radius = 0;
            }
        } else if (++timer >= 20) {
            timer = 0;
            PrimordialCoreOnTickUpdateProcedure.infectSphere(world, pos, radius, x, y, z);
            if (radius < 65) {
                ++radius;
            }
            if (maxRadius < radius) {
                expanding = false;
                ++maxRadius;
                radius = 0;
            }
        }
        data.m_128405_("timer", timer);
        data.m_128405_("radius", radius);
        data.m_128405_("maxRadius", maxRadius);
        data.m_128379_("expanding", expanding);
    }

    private static void infectSphere(LevelAccessor world, BlockPos center, int radius, double x, double y, double z) {
        int thickness = 1;
        int outer = radius * radius;
        int inner = (radius - thickness) * (radius - thickness);
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockEntity targetEntity;
                    int dist2 = dx * dx + dy * dy + dz * dz;
                    if (dist2 > outer || dist2 < inner || Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)1, (int)5) == 3) continue;
                    BlockPos currentPos = center.m_7918_(dx, dy, dz);
                    BlockState state = world.m_8055_(currentPos);
                    Block block = state.m_60734_();
                    boolean hasTaggedNeighbor = false;
                    for (Direction dir : Direction.values()) {
                        BlockPos neighborPos = currentPos.m_121945_(dir);
                        BlockState neighborState = world.m_8055_(neighborPos);
                        if (!neighborState.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("harmony:propagation_blocks")))) continue;
                        hasTaggedNeighbor = true;
                        break;
                    }
                    if ((targetEntity = world.m_7702_(currentPos)) instanceof Container) {
                        PrimordialCoreOnTickUpdateProcedure.spoilFoodInInventory(world, currentPos);
                    }
                    if (!hasTaggedNeighbor || state.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("harmony:blocks")))) continue;
                    if (!state.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("minecraft:fences_and_walls")))) {
                        BlockState newState = PrimordialCoreOnTickUpdateProcedure.getInfectedState(block, state);
                        if (newState != null) {
                            world.m_7731_(currentPos, newState, 3);
                            if (!(world instanceof ServerLevel)) continue;
                            ServerLevel _level = (ServerLevel)world;
                            _level.m_7654_().m_129892_().m_230957_(new CommandSourceStack(CommandSource.f_80164_, new Vec3(x, y, z), Vec2.f_82462_, _level, 4, "", (Component)Component.m_237113_((String)""), _level.m_7654_(), null).m_81324_(), "fillbiome " + (int)((double)dx + x) + " " + (int)((double)dy + y) + " " + (int)((double)dz + z) + " " + (int)((double)dx + x) + " 250 " + (int)((double)dz + z) + " harmony_symbiotic_ascension:symbiont_forest");
                            continue;
                        }
                        if (!state.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("harmony:infection_breakables"))) || Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)0, (int)1) != 1) continue;
                        world.m_46961_(currentPos, false);
                        continue;
                    }
                    FenceRemoverProcedure.removeConnectedFences(world, currentPos);
                    if (!(world instanceof ServerLevel)) continue;
                    ServerLevel _level = (ServerLevel)world;
                    _level.m_5594_(null, currentPos, SoundEvents.f_12601_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
        }
    }

    private static BlockState getInfectedState(Block block, BlockState currentState) {
        if (block == null || !currentState.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("harmony:infectable_blocks")))) {
            return null;
        }
        if (currentState.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("minecraft:dirt"))) || block.toString().contains("moss") && !currentState.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("minecraft:cobble_blocks")))) {
            return PrimordialCoreOnTickUpdateProcedure.withFacingOrAxis(((Block)HarmonySymbioticAscensionModBlocks.SYMBIOTIC_BLOOM.get()).m_49966_(), currentState);
        }
        if (block.toString().contains("cobble")) {
            if (currentState.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("minecraft:cobblestone")))) {
                return ((Block)HarmonySymbioticAscensionModBlocks.MORPHED_COBBLESTONE.get()).m_49966_();
            }
            if (currentState.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("minecraft:cobblestone_stairs")))) {
                return PrimordialCoreOnTickUpdateProcedure.withFacingOrAxis(((Block)HarmonySymbioticAscensionModBlocks.MORPHED_COBBLESTONE_STAIRS.get()).m_49966_(), currentState);
            }
            if (currentState.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("minecraft:cobblestone_slabs")))) {
                return PrimordialCoreOnTickUpdateProcedure.withFacingOrAxis(((Block)HarmonySymbioticAscensionModBlocks.MORPHED_COBBLESTONE_SLAB.get()).m_49966_(), currentState);
            }
            return null;
        }
        if (block.toString().contains("brick")) {
            if (currentState.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("minecraft:stone_bricks")))) {
                return ((Block)HarmonySymbioticAscensionModBlocks.MORPHED_STONE_BRICKS.get()).m_49966_();
            }
            if (currentState.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("minecraft:stone_brick_stairs")))) {
                return PrimordialCoreOnTickUpdateProcedure.withFacingOrAxis(((Block)HarmonySymbioticAscensionModBlocks.MORPHED_STONE_BRICK_STAIRS.get()).m_49966_(), currentState);
            }
            if (currentState.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("minecraft:stone_brick_slabs")))) {
                return PrimordialCoreOnTickUpdateProcedure.withFacingOrAxis(((Block)HarmonySymbioticAscensionModBlocks.MORPHED_STONE_BRICK_SLAB.get()).m_49966_(), currentState);
            }
            return null;
        }
        if (block.toString().contains("stone") || block.toString().contains("andesite") || block.toString().contains("diorite") || block.toString().contains("granite") || block.toString().contains("deepslate")) {
            if (currentState.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("minecraft:stone")))) {
                return ((Block)HarmonySymbioticAscensionModBlocks.PRIMORDIAL_STONE.get()).m_49966_();
            }
            if (currentState.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("minecraft:stone_stairs")))) {
                return PrimordialCoreOnTickUpdateProcedure.withFacingOrAxis(((Block)HarmonySymbioticAscensionModBlocks.PRIMORDIAL_STONE_STAIRS.get()).m_49966_(), currentState);
            }
            if (currentState.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("minecraft:stone_slabs")))) {
                return PrimordialCoreOnTickUpdateProcedure.withFacingOrAxis(((Block)HarmonySymbioticAscensionModBlocks.PRIMORDIAL_STONE_SLAB.get()).m_49966_(), currentState);
            }
            return null;
        }
        if (block.toString().contains("planks")) {
            return ((Block)HarmonySymbioticAscensionModBlocks.SYMBIOTIC_PLANKS.get()).m_49966_();
        }
        if (block.toString().contains("stairs") && currentState.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("minecraft:wooden_stairs")))) {
            return PrimordialCoreOnTickUpdateProcedure.withFacingOrAxis(((Block)HarmonySymbioticAscensionModBlocks.SYMBIOTIC_STAIRS.get()).m_49966_(), currentState);
        }
        if (block.toString().contains("slab") && currentState.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("minecraft:wooden_slabs")))) {
            return PrimordialCoreOnTickUpdateProcedure.withFacingOrAxis(((Block)HarmonySymbioticAscensionModBlocks.SYMBIOTIC_SLAB.get()).m_49966_(), currentState);
        }
        if (block.toString().contains("log") && currentState.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("minecraft:logs")))) {
            return PrimordialCoreOnTickUpdateProcedure.withFacingOrAxis(((Block)HarmonySymbioticAscensionModBlocks.LOG_VEIN.get()).m_49966_(), currentState);
        }
        if (block.toString().contains("wood") && currentState.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("minecraft:woods")))) {
            return PrimordialCoreOnTickUpdateProcedure.withFacingOrAxis(((Block)HarmonySymbioticAscensionModBlocks.WOOD_VEIN.get()).m_49966_(), currentState);
        }
        if (currentState.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("minecraft:ores")))) {
            if (currentState.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("minecraft:coal_ores")))) {
                return ((Block)HarmonySymbioticAscensionModBlocks.PRIMORDIAL_COAL_ORE.get()).m_49966_();
            }
            if (currentState.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("minecraft:copper_ores")))) {
                return ((Block)HarmonySymbioticAscensionModBlocks.PRIMORDIAL_COPPER_ORE.get()).m_49966_();
            }
            if (currentState.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("minecraft:iron_ores")))) {
                return ((Block)HarmonySymbioticAscensionModBlocks.PRIMORDIAL_IRON_ORE.get()).m_49966_();
            }
            if (currentState.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("minecraft:gold_ores")))) {
                return ((Block)HarmonySymbioticAscensionModBlocks.PRIMORDIAL_GOLD_ORE.get()).m_49966_();
            }
            if (currentState.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("minecraft:redstone_ores")))) {
                return ((Block)HarmonySymbioticAscensionModBlocks.PRIMORDIAL_REDSTONE_ORE.get()).m_49966_();
            }
            if (currentState.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("minecraft:diamond_ores")))) {
                return ((Block)HarmonySymbioticAscensionModBlocks.PRIMORDIAL_DIAMOND_ORE.get()).m_49966_();
            }
            if (currentState.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("minecraft:lapis_ores")))) {
                return ((Block)HarmonySymbioticAscensionModBlocks.PRIMORDIAL_LAPIS_LAZULI_ORE.get()).m_49966_();
            }
            if (currentState.m_204336_(BlockTags.create((ResourceLocation)new ResourceLocation("minecraft:emerald_ores")))) {
                return ((Block)HarmonySymbioticAscensionModBlocks.PRIMORDIAL_EMERALD_ORE.get()).m_49966_();
            }
        }
        return null;
    }

    private static BlockState withFacingOrAxis(BlockState baseState, BlockState fromState) {
        BlockState newState = baseState;
        Property prop = newState.m_60734_().m_49965_().m_61081_("facing");
        if (prop instanceof DirectionProperty && fromState.m_60734_().m_49965_().m_61081_("facing") != null) {
            newState = (BlockState)newState.m_61124_((Property)((DirectionProperty)prop), (Comparable)((Direction)fromState.m_61143_((Property)((DirectionProperty)fromState.m_60734_().m_49965_().m_61081_("facing")))));
        } else {
            prop = newState.m_60734_().m_49965_().m_61081_("axis");
            if (prop instanceof EnumProperty && fromState.m_60734_().m_49965_().m_61081_("axis") != null) {
                newState = (BlockState)newState.m_61124_((Property)((EnumProperty)prop), fromState.m_61143_((Property)((EnumProperty)fromState.m_60734_().m_49965_().m_61081_("axis"))));
            }
        }
        for (Map.Entry entry : fromState.m_61148_().entrySet()) {
            Property targetProp = newState.m_60734_().m_49965_().m_61081_(((Property)entry.getKey()).m_61708_());
            if (targetProp == null) continue;
            try {
                newState = (BlockState)newState.m_61124_(targetProp, (Comparable)entry.getValue());
            }
            catch (Exception exception) {}
        }
        return newState;
    }

    public static void spoilFoodInInventory(LevelAccessor world, BlockPos pos) {
        if (world == null || world.m_5776_()) {
            return;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof Container) {
            Container container = (Container)blockEntity;
            int size = container.m_6643_();
            for (int i = 0; i < size; ++i) {
                boolean isDrink;
                FoodProperties foodProps;
                Item item;
                ItemStack stack = container.m_8020_(i);
                if (stack.m_41619_() || !(item = stack.m_41720_()).m_41472_() || (foodProps = item.m_41473_()) == null || foodProps.m_38747_() || foodProps.m_38748_()) continue;
                boolean bl = isDrink = item.toString().toLowerCase().contains("drink") || item.toString().toLowerCase().contains("bottle") || item.toString().toLowerCase().contains("juice");
                if (isDrink || stack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("btw:cans"))) || stack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("harmony:foods")))) continue;
                ItemStack spoiledStack = new ItemStack((ItemLike)HarmonySymbioticAscensionModItems.SYMBIOTIC_SPOILED_FOOD.get(), stack.m_41613_());
                container.m_6836_(i, spoiledStack);
            }
            blockEntity.m_6596_();
        }
    }
}

