/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.harmonysymbioticascension.procedures;

import java.util.Random;
import java.util.function.Function;
import net.mcreator.harmonysymbioticascension.init.HarmonySymbioticAscensionModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class SpawnResiduesProcedure {
    private static final TagKey<Block> RESIDUE_TAG = BlockTags.create((ResourceLocation)new ResourceLocation("harmony", "residues"));

    public static void execute(LevelAccessor world, BlockPos pos, Entity entity) {
        ServerLevel serverLevel;
        block3: {
            block2: {
                if (!(world instanceof ServerLevel)) break block2;
                serverLevel = (ServerLevel)world;
                if (entity != null) break block3;
            }
            return;
        }
        Random random = new Random();
        float sizeFactor = entity.m_20205_() * entity.m_20206_();
        sizeFactor = Math.max(0.5f, Math.min(sizeFactor, 6.0f));
        int bigCount = 1 + (int)(sizeFactor / 3.0f);
        int mediumCount = 1 + (int)(sizeFactor / 2.0f);
        int smallCount = 2 + (int)(sizeFactor * 2.0f);
        BlockState bigResidue = SpawnResiduesProcedure.getRandomBig(random);
        SpawnResiduesProcedure.placeResidueIfFree(serverLevel, pos, bigResidue);
        SpawnResiduesProcedure.spawnAround(serverLevel, pos, mediumCount, 2, r -> SpawnResiduesProcedure.getRandomMedium(r));
        SpawnResiduesProcedure.spawnAround(serverLevel, pos, smallCount, 3, r -> SpawnResiduesProcedure.getRandomSmall(r));
    }

    private static void placeResidueIfFree(ServerLevel world, BlockPos pos, BlockState residue) {
        if (world.m_8055_(pos).m_247087_()) {
            world.m_7731_(pos, residue, 3);
        }
    }

    private static void spawnAround(ServerLevel world, BlockPos center, int count, int radius, Function<Random, BlockState> picker) {
        Random random = new Random();
        for (int i = 0; i < count; ++i) {
            double gx = random.nextGaussian() * ((double)radius * 0.2);
            double gz = random.nextGaussian() * ((double)radius * 0.2);
            int dx = (int)Math.round(gx);
            int dz = (int)Math.round(gz);
            BlockPos rawPos = center.m_7918_(dx, 0, dz);
            BlockPos fixedPos = SpawnResiduesProcedure.fixSpawnPos(world, rawPos);
            BlockPos below = fixedPos.m_7495_();
            if (!world.m_8055_(fixedPos).m_247087_() || world.m_8055_(below).m_204336_(RESIDUE_TAG)) continue;
            world.m_7731_(fixedPos, picker.apply(random), 3);
        }
    }

    private static BlockState getRandomSmall(Random r) {
        double roll = r.nextDouble() * 2.44;
        if (roll < 1.0) {
            return ((Block)HarmonySymbioticAscensionModBlocks.RESIDUES_1.get()).m_49966_();
        }
        if (roll < 1.8) {
            return ((Block)HarmonySymbioticAscensionModBlocks.RESIDUES_4.get()).m_49966_();
        }
        return ((Block)HarmonySymbioticAscensionModBlocks.RESIDUES_7.get()).m_49966_();
    }

    private static BlockState getRandomMedium(Random r) {
        double roll = r.nextDouble() * 2.44;
        if (roll < 1.0) {
            return ((Block)HarmonySymbioticAscensionModBlocks.RESIDUES_2.get()).m_49966_();
        }
        if (roll < 1.8) {
            return ((Block)HarmonySymbioticAscensionModBlocks.RESIDUES_5.get()).m_49966_();
        }
        return ((Block)HarmonySymbioticAscensionModBlocks.RESIDUES_8.get()).m_49966_();
    }

    private static BlockState getRandomBig(Random r) {
        double roll = r.nextDouble() * 2.44;
        if (roll < 1.0) {
            return ((Block)HarmonySymbioticAscensionModBlocks.RESIDUES_3.get()).m_49966_();
        }
        if (roll < 1.8) {
            return ((Block)HarmonySymbioticAscensionModBlocks.RESIDUES_6.get()).m_49966_();
        }
        return ((Block)HarmonySymbioticAscensionModBlocks.RESIDUES_9.get()).m_49966_();
    }

    private static BlockPos fixSpawnPos(ServerLevel world, BlockPos pos) {
        BlockPos check = pos;
        while (world.m_8055_(check).m_247087_() && world.m_8055_(check.m_7495_()).m_247087_() && check.m_123342_() > world.m_141937_()) {
            check = check.m_7495_();
        }
        while (!world.m_8055_(check).m_247087_() && check.m_123342_() < world.m_151558_()) {
            check = check.m_7494_();
        }
        return check;
    }
}

