/*
 * Decompiled with CFR 0.152.
 */
package dev.polaris.animights.common.entity;

import dev.polaris.animights.common.entity.ai.RangedAttackGoal;
import dev.xylonity.knightlib.api.scheduler.TickScheduler;
import dev.xylonity.knightlib.registry.KnightLibItems;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import org.antlr.v4.runtime.misc.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class AbstractCompanionEntity
extends TamableAnimal
implements GeoEntity,
RangedAttackMob {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation SIT = RawAnimation.begin().thenPlay("sit");
    private final RawAnimation ATTACK = RawAnimation.begin().thenPlay("attack");
    private static final EntityDataAccessor<Integer> MAIN_ACTION = SynchedEntityData.m_135353_(AbstractCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_SITTING = SynchedEntityData.m_135353_(AbstractCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    protected AbstractCompanionEntity(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.m_21553_(true);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, new RangedAttackGoal<AbstractCompanionEntity>(this, 0.7, 10, 15.0f));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.6, true){

            protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
                double d0 = this.m_6639_(enemy);
                if (distToEnemySqr <= d0 && this.m_25565_() <= 0) {
                    this.m_25563_();
                    TickScheduler.scheduleServer((Level)AbstractCompanionEntity.this.m_9236_(), () -> this.f_25540_.m_7327_((Entity)enemy), (int)12);
                    this.f_25540_.m_6674_(InteractionHand.OFF_HAND);
                }
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new FollowOwnerGoal((TamableAnimal)this, 0.6, 6.0f, 2.0f, false));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
    }

    public static AttributeSupplier.Builder setAttributes() {
        return TamableAnimal.m_21552_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22283_, 2.0).m_22268_(Attributes.f_22279_, 0.5);
    }

    public void setMainAction(int action, @Nullable Player player) {
        ArrayList<Integer> allowedActions = new ArrayList<Integer>();
        allowedActions.add(0);
        allowedActions.add(1);
        int newAction = (Integer)allowedActions.get(action % allowedActions.size());
        this.f_19804_.m_135381_(MAIN_ACTION, (Object)newAction);
        if (player != null) {
            switch (newAction) {
                case 0: {
                    player.m_5661_((Component)Component.m_237110_((String)"main_action.animights.client_message.is_sitting", (Object[])new Object[]{this.m_7755_()}), true);
                    break;
                }
                case 1: {
                    player.m_5661_((Component)Component.m_237110_((String)"main_action.animights.client_message.is_following", (Object[])new Object[]{this.m_7755_()}), true);
                    break;
                }
                case 2: {
                    player.m_5661_((Component)Component.m_237110_((String)"main_action.animights.client_message.is_wandering", (Object[])new Object[]{this.m_7755_()}), true);
                    break;
                }
                default: {
                    player.m_5661_((Component)Component.m_237110_((String)"main_action.animights.client_message.is_working", (Object[])new Object[]{this.m_7755_()}), true);
                }
            }
        }
    }

    public int getMainAction() {
        return (Integer)this.f_19804_.m_135370_(MAIN_ACTION);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("CompanionsMainAction")) {
            this.setMainAction(pCompound.m_128451_("CompanionsMainAction"), null);
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            CompoundTag stackNbt;
            ItemStack stack;
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || (stack = ItemStack.m_41712_((CompoundTag)(stackNbt = pCompound.m_128469_(slot.m_20751_())))).m_41619_()) continue;
            this.m_8061_(slot, stack);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.m_9236_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_6144_()) {
            this.dropNextEquippedItemAtFeet(player);
            return InteractionResult.SUCCESS;
        }
        if (this.handleDefaultMainActionAndHeal(player, hand)) {
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    private void dropNextEquippedItemAtFeet(Player player) {
        EquipmentSlot[] armorOrder;
        if (!this.m_21120_(InteractionHand.OFF_HAND).m_41619_()) {
            this.dropSlotItem(EquipmentSlot.OFFHAND);
            return;
        }
        if (!this.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
            this.dropSlotItem(EquipmentSlot.MAINHAND);
            return;
        }
        for (EquipmentSlot slot : armorOrder = new EquipmentSlot[]{EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.HEAD, EquipmentSlot.FEET}) {
            ItemStack stack = this.m_6844_(slot);
            if (stack.m_41619_()) continue;
            this.dropSlotItem(slot);
            return;
        }
    }

    private boolean dropSlotItem(EquipmentSlot slot) {
        ItemStack stack = this.m_6844_(slot);
        if (stack.m_41619_()) {
            return false;
        }
        ItemStack drop = stack.m_41777_();
        this.m_8061_(slot, ItemStack.f_41583_);
        drop.m_41754_(20);
        this.m_19983_(drop);
        this.m_5496_(SoundEvents.f_12019_, 0.35f, 0.9f + this.m_217043_().m_188501_() * 0.2f);
        return true;
    }

    public boolean handleDefaultMainActionAndHeal(Player pPlayer, InteractionHand hand) {
        if (this.m_9236_().f_46443_) {
            return true;
        }
        ItemStack stack = pPlayer.m_21120_(hand);
        Item item = stack.m_41720_();
        if (this.m_21824_() && pPlayer == this.m_269323_()) {
            if (item == KnightLibItems.SMALL_ESSENCE.get() && this.m_21223_() != this.m_21233_()) {
                if (!pPlayer.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                this.m_5634_(this.m_21223_() * 0.05f);
                this.summonHealParticles();
            } else if (item == KnightLibItems.GREAT_ESSENCE.get() && this.m_21223_() != this.m_21233_()) {
                if (!pPlayer.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                this.m_5634_(this.m_21223_() * 0.2f);
                this.summonHealParticles();
            } else {
                this.defaultMainActionInteraction(pPlayer);
            }
            return true;
        }
        return false;
    }

    private void summonHealParticles() {
        for (int i = 0; i < 10; ++i) {
            double dx = (this.f_19796_.m_188500_() - 0.5) * 1.25;
            double dy = (this.f_19796_.m_188500_() - 0.5) * 1.25;
            double dz = (this.f_19796_.m_188500_() - 0.5) * 1.25;
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            if (!(level2.f_46441_.m_188501_() < 0.45f)) continue;
            level2.m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_() + 0.15, this.m_20189_(), 1, dx, dy, dz, 0.1);
        }
    }

    public void defaultMainActionInteraction(Player pPlayer) {
        this.setMainAction(this.getMainAction() + 1, pPlayer);
        if (this.getMainAction() == 0) {
            this.setSitting(true);
            this.m_6710_(null);
            this.m_21839_(true);
        } else {
            this.m_21839_(false);
            this.setSitting(false);
        }
    }

    public boolean isSitting() {
        return (Boolean)this.f_19804_.m_135370_(IS_SITTING);
    }

    public void setSitting(boolean isSitting) {
        this.f_19804_.m_135381_(IS_SITTING, (Object)isSitting);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MAIN_ACTION, (Object)1);
        this.f_19804_.m_135372_(IS_SITTING, (Object)false);
    }

    protected void m_7581_(ItemEntity itemEntity) {
        ItemStack itemStack = itemEntity.m_32055_();
        Item item = itemStack.m_41720_();
        if ((item instanceof SwordItem || item instanceof AxeItem || item instanceof ProjectileWeaponItem) && this.m_21824_()) {
            EquipmentSlot slot = LivingEntity.m_147233_((ItemStack)itemStack);
            ItemStack currentItem = this.m_21120_(InteractionHand.MAIN_HAND);
            if (currentItem.m_41619_()) {
                this.m_8061_(slot, itemStack.m_41620_(1));
                if (itemStack.m_41619_()) {
                    itemEntity.m_146870_();
                }
            }
        } else if (item instanceof ArmorItem) {
            EquipmentSlot slot;
            ItemStack currentArmor;
            ArmorItem armorItem = (ArmorItem)item;
            if (this.m_21824_() && (currentArmor = this.m_6844_(slot = armorItem.m_40402_())).m_41619_()) {
                this.m_8061_(slot, itemStack.m_41620_(1));
                if (itemStack.m_41619_()) {
                    itemEntity.m_146870_();
                }
            }
        }
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        if (tag.m_128403_("ownerUUID")) {
            this.m_21816_(tag.m_128342_("ownerUUID"));
        }
        tag.m_128379_("isSitting", this.isSitting());
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack;
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || (stack = this.m_6844_(slot)).m_41619_()) continue;
            CompoundTag stackNbt = new CompoundTag();
            stack.m_41739_(stackNbt);
            tag.m_128365_(slot.m_20751_(), (Tag)stackNbt);
        }
    }

    public void m_6504_(@NotNull LivingEntity pTarget, float pVelocity) {
        ItemStack itemstack = this.m_6298_(this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrow abstractarrow = this.getArrow(itemstack, pVelocity);
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            abstractarrow = ((BowItem)this.m_21205_().m_41720_()).customArrow(abstractarrow);
        }
        double d0 = pTarget.m_20185_() - this.m_20185_();
        double d1 = pTarget.m_20227_(0.34) - abstractarrow.m_20186_();
        double d2 = pTarget.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        abstractarrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.m_9236_().m_46791_().m_19028_() * 4));
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)abstractarrow);
    }

    protected AbstractArrow getArrow(ItemStack pArrowStack, float pVelocity) {
        return ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)pArrowStack, (float)pVelocity);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackcontroller", 2, this::attackPredicate)});
    }

    private <T extends GeoAnimatable> PlayState attackPredicate(AnimationState<T> event) {
        if (this.f_20911_ && event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            event.getController().forceAnimationReset();
            event.getController().setAnimation(this.ATTACK);
            this.f_20911_ = false;
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.isSitting()) {
            event.setAnimation(this.SIT);
        } else if (event.isMoving()) {
            event.setAnimation(this.WALK);
        } else {
            event.setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

