/*
 * Decompiled with CFR 0.152.
 */
package com.criticalpickle.criticalcrates;

import com.criticalpickle.criticalcrates.Config;
import com.criticalpickle.criticalcrates.block.entity.CrateBlockEntity;
import com.criticalpickle.criticalcrates.registration.ModBlockEntities;
import com.criticalpickle.criticalcrates.registration.ModItems;
import com.criticalpickle.criticalcrates.registration.ModRegistration;
import com.criticalpickle.criticalcrates.util.HolderUtils;
import com.mojang.logging.LogUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;

@Mod(value="criticalcrates")
public class CriticalCrates {
    public static final String MODID = "criticalcrates";
    public static final Logger LOGGER = LogUtils.getLogger();

    public CriticalCrates(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onRegisterCapabilities);
        ModRegistration.init(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(ModRegistration::addCreative);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Thanks for downloading Critical Crates! Setting up...");
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Critical Crates is now being loaded on the server!");
        RegistryAccess.Frozen holderLookUpProvider = event.getServer().registryAccess();
        HolderUtils.setHolderLookup((HolderLookup.Provider)holderLookUpProvider);
    }

    public void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.Item.BLOCK, ModBlockEntities.CRATE_BE.get(), CrateBlockEntity::getInventorySide);
        event.registerBlockEntity(Capabilities.Item.BLOCK, ModBlockEntities.GLASS_CRATE_BE.get(), CrateBlockEntity::getInventorySide);
    }

    @SubscribeEvent
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        ItemStack stack = null;
        CustomData data = null;
        for (int i = 0; i < event.getInventory().getContainerSize(); ++i) {
            stack = event.getInventory().getItem(i);
            data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
            if (stack.isEmpty() || stack.getItem() != ModItems.PLIERS_ITEM.get() || data == null || !((Boolean)data.copyTag().getBoolean("broken").get()).booleanValue()) continue;
            event.getEntity().level().playSound(null, event.getEntity().blockPosition(), (SoundEvent)SoundEvents.ITEM_BREAK.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
            break;
        }
    }
}

