/*
 * Decompiled with CFR 0.152.
 */
package com.criticalpickle.criticalcrates.block.entity;

import com.criticalpickle.criticalcrates.block.CrateBlock;
import com.criticalpickle.criticalcrates.registration.ModBlockEntities;
import com.criticalpickle.criticalcrates.screen.CrateMenu;
import com.criticalpickle.criticalcrates.util.CacheSwitchInventory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ItemStacksResourceHandler;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.jetbrains.annotations.Nullable;

public class CrateBlockEntity
extends BlockEntity
implements MenuProvider {
    public final ItemStacksResourceHandler inventory = new ItemStacksResourceHandler(27){

        protected void onContentsChanged(int index, ItemStack previousContents) {
            CrateBlockEntity.this.setChanged();
            if (CrateBlockEntity.this.level != null && !CrateBlockEntity.this.level.isClientSide()) {
                CrateBlockEntity.this.level.sendBlockUpdated(CrateBlockEntity.this.getBlockPos(), CrateBlockEntity.this.getBlockState(), CrateBlockEntity.this.getBlockState(), 3);
            }
        }
    };

    public CrateBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.CRATE_BE.get(), pos, blockState);
    }

    public CrateBlockEntity(BlockEntityType entity, BlockPos pos, BlockState blockState) {
        super(entity, pos, blockState);
    }

    public void drop() {
        SimpleContainer containerInv = new SimpleContainer(this.inventory.size());
        for (int i = 0; i < this.inventory.size(); ++i) {
            ItemStack stack = ((ItemResource)this.inventory.getResource(i)).toStack();
            stack.setCount(this.inventory.getAmountAsInt(i));
            containerInv.setItem(i, stack);
        }
        if (this.level != null) {
            Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)containerInv);
        }
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        if (((Boolean)state.getValue((Property)CrateBlock.SWITCH)).booleanValue()) {
            CacheSwitchInventory.cache(this.getInventory());
        } else {
            this.drop();
        }
        super.preRemoveSideEffects(pos, state);
    }

    public ItemStacksResourceHandler getInventory() {
        return this.inventory;
    }

    public void copyInventory(ItemStacksResourceHandler oldInventory) {
        if (oldInventory != null) {
            for (int i = 0; i < this.inventory.size(); ++i) {
                this.inventory.set(i, (Resource)((ItemResource)oldInventory.getResource(i)), oldInventory.getAmountAsInt(i));
            }
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.getLevel() != null && !this.getLevel().isClientSide() && ((Boolean)this.getBlockState().getValue((Property)CrateBlock.SWITCH)).booleanValue()) {
            this.getLevel().setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)CrateBlock.SWITCH, (Comparable)Boolean.valueOf(false)));
        }
    }

    public ResourceHandler<ItemResource> getInventorySide(Direction side) {
        if (side == Direction.DOWN) {
            return new SideHandler(this.inventory, false, true);
        }
        return new SideHandler(this.inventory, true, false);
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        this.inventory.serialize(output);
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.inventory.deserialize(input);
        if (input.child("inventory").isPresent()) {
            NonNullList stacks = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
            ContainerHelper.loadAllItems((ValueInput)((ValueInput)input.child("inventory").get()), (NonNullList)stacks);
            ItemStacksResourceHandler temp = new ItemStacksResourceHandler(stacks);
            this.copyInventory(temp);
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.criticalcrates.crate");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new CrateMenu(id, inventory, this);
    }

    private record SideHandler(ItemStacksResourceHandler handler, boolean isInsert, boolean isExtract) implements ResourceHandler<ItemResource>
    {
        public int size() {
            return this.handler.size();
        }

        public ItemResource getResource(int i) {
            return (ItemResource)this.handler.getResource(i);
        }

        public long getAmountAsLong(int i) {
            return this.handler.getAmountAsLong(i);
        }

        public long getCapacityAsLong(int i, ItemResource resource) {
            return this.handler.getCapacityAsLong(i, (Resource)resource);
        }

        public boolean isValid(int i, ItemResource resource) {
            return this.handler.isValid(i, (Resource)resource);
        }

        public int insert(int i, ItemResource resource, int amount, TransactionContext transactionContext) {
            return this.isInsert ? this.handler.insert(i, (Resource)resource, amount, transactionContext) : 0;
        }

        public int extract(int i, ItemResource resource, int amount, TransactionContext transactionContext) {
            return this.isExtract ? this.handler.extract(i, (Resource)resource, amount, transactionContext) : 0;
        }
    }
}

