/*
 * Decompiled with CFR 0.152.
 */
package com.criticalpickle.criticalcrates.datagen;

import com.criticalpickle.criticalcrates.datagen.ModBlockLootTableProvider;
import com.criticalpickle.criticalcrates.datagen.ModBlockTagProvider;
import com.criticalpickle.criticalcrates.datagen.ModItemTagProvider;
import com.criticalpickle.criticalcrates.datagen.ModModelProvider;
import com.criticalpickle.criticalcrates.datagen.ModRecipeProvider;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="criticalcrates")
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        event.addProvider((DataProvider)new LootTableProvider(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(ModBlockLootTableProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
        ModBlockTagProvider blockTagsProvider = new ModBlockTagProvider(packOutput, lookupProvider);
        generator.addProvider(true, (DataProvider)blockTagsProvider);
        generator.addProvider(true, (DataProvider)new ModItemTagProvider(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new ModModelProvider(packOutput));
        generator.addProvider(true, (DataProvider)new ModRecipeProvider.Runner(packOutput, lookupProvider));
    }
}

