/*
 * Decompiled with CFR 0.152.
 */
package com.criticalpickle.criticalcrates.datagen;

import com.criticalpickle.criticalcrates.block.CrateBlock;
import com.criticalpickle.criticalcrates.block.GlassCrateBlock;
import com.criticalpickle.criticalcrates.registration.ModBlocks;
import com.criticalpickle.criticalcrates.registration.ModItems;
import com.criticalpickle.criticalcrates.util.IDUtils;
import com.criticalpickle.criticalcrates.util.ItemModelPropertyUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.MultiVariant;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.blockstates.PropertyDispatch;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.block.model.VariantMutator;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.SelectItemModel;
import net.minecraft.client.renderer.item.properties.select.SelectItemModelProperty;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;

public class ModModelProvider
extends ModelProvider {
    public ModModelProvider(PackOutput output) {
        super(output, "criticalcrates");
    }

    protected void registerModels(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
        int i;
        for (i = 0; i < ModItems.getCrateItems().length; ++i) {
            this.blockItemWithOverrides(ModItems.getCrateItems(i), itemModels);
        }
        for (i = 0; i < ModBlocks.getCrates().length; ++i) {
            this.axisWithOtherPropertiesCrateBlock(ModBlocks.getCrates(i), blockModels);
        }
        itemModels.generateFlatItem((Item)ModItems.PLIERS_ITEM.get(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem((Item)ModItems.OBSIDIAN_REINFORCEMENT_ITEM.get(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem((Item)ModItems.LAMP_SIMULATOR_ITEM.get(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem((Item)ModItems.FIREPROOFING_ITEM.get(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem((Item)ModItems.SLIMY_FRAMING_ITEM.get(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem((Item)ModItems.SOAP.get(), ModelTemplates.FLAT_ITEM);
    }

    private void axisWithOtherPropertiesCrateBlock(Block block, BlockModelGenerators blockModels) {
        String blockName = IDUtils.getItemID(block.asItem());
        String blockType = block instanceof GlassCrateBlock ? "glass" : "wood";
        Identifier baseLoc = Identifier.fromNamespaceAndPath((String)"criticalcrates", (String)("block/" + blockName));
        Identifier resistantLoc = Identifier.fromNamespaceAndPath((String)"criticalcrates", (String)("block/" + blockName + "_resistant"));
        Identifier lampLoc = Identifier.fromNamespaceAndPath((String)"criticalcrates", (String)("block/" + blockName + "_lamp"));
        Identifier lampOnLoc = Identifier.fromNamespaceAndPath((String)"criticalcrates", (String)("block/" + blockName + "_lamp_on"));
        Identifier fireLoc = Identifier.fromNamespaceAndPath((String)"criticalcrates", (String)("block/" + blockName + "_fireproof"));
        Identifier slimyLoc = Identifier.fromNamespaceAndPath((String)"criticalcrates", (String)("block/" + blockName + "_slimy"));
        Variant base = new Variant(baseLoc);
        Map<String, ModelTemplate> templates = ModModelProvider.generateTemplates(block, blockName, blockType);
        for (Map.Entry<String, ModelTemplate> template : templates.entrySet()) {
            Identifier textureLoc = Identifier.fromNamespaceAndPath((String)"criticalcrates", (String)("block/" + blockType + "/" + blockName + template.getKey()));
            Identifier textureLocTop = Identifier.fromNamespaceAndPath((String)"criticalcrates", (String)("block/" + blockType + "/" + blockName + template.getKey() + "_top"));
            template.getValue().create(block, new TextureMapping().put(TextureSlot.SIDE, textureLoc).put(TextureSlot.END, textureLocTop), blockModels.modelOutput);
        }
        blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block, (MultiVariant)BlockModelGenerators.variant((Variant)base)).with((PropertyDispatch)PropertyDispatch.modify(CrateBlock.AXIS).select((Comparable)Direction.Axis.Y, (Object)BlockModelGenerators.NOP).select((Comparable)Direction.Axis.Z, (Object)BlockModelGenerators.X_ROT_90).select((Comparable)Direction.Axis.X, (Object)BlockModelGenerators.X_ROT_90.then(BlockModelGenerators.Y_ROT_90))).with((PropertyDispatch)PropertyDispatch.modify((Property)CrateBlock.EXPLOSION_RESIST).select((Comparable)Boolean.valueOf(true), (Object)VariantMutator.MODEL.withValue((Object)resistantLoc)).select((Comparable)Boolean.valueOf(false), (Object)BlockModelGenerators.NOP)).with((PropertyDispatch)PropertyDispatch.modify((Property)CrateBlock.LAMP_UPGRADE, (Property)CrateBlock.LIT).select((Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(false), (Object)VariantMutator.MODEL.withValue((Object)lampLoc)).select((Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(true), (Object)VariantMutator.MODEL.withValue((Object)lampOnLoc)).select((Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(false), (Object)BlockModelGenerators.NOP).select((Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(true), (Object)BlockModelGenerators.NOP)).with((PropertyDispatch)PropertyDispatch.modify((Property)CrateBlock.FIREPROOF).select((Comparable)Boolean.valueOf(true), (Object)VariantMutator.MODEL.withValue((Object)fireLoc)).select((Comparable)Boolean.valueOf(false), (Object)BlockModelGenerators.NOP)).with((PropertyDispatch)PropertyDispatch.modify((Property)CrateBlock.SLIMY).select((Comparable)Boolean.valueOf(true), (Object)VariantMutator.MODEL.withValue((Object)slimyLoc)).select((Comparable)Boolean.valueOf(false), (Object)BlockModelGenerators.NOP)));
    }

    private static Map<String, ModelTemplate> generateTemplates(Block block, String blockName, String blockType) {
        HashMap<String, ModelTemplate> templates = new HashMap<String, ModelTemplate>();
        String key = "";
        ModelTemplate BASE_TEMPLATE = ModModelProvider.createTemplate(blockName, key, blockType, block.getDescriptionId().contains("criticalcrates"));
        templates.put(key, BASE_TEMPLATE);
        key = "_resistant";
        ModelTemplate RESISTANT_TEMPLATE = ModModelProvider.createTemplate(blockName, key, blockType, block.getDescriptionId().contains("criticalcrates"));
        templates.put(key, RESISTANT_TEMPLATE);
        key = "_lamp";
        ModelTemplate LAMP_TEMPLATE = ModModelProvider.createTemplate(blockName, key, blockType, block.getDescriptionId().contains("criticalcrates"));
        templates.put(key, LAMP_TEMPLATE);
        key = "_lamp_on";
        ModelTemplate LAMP_ON_TEMPLATE = ModModelProvider.createTemplate(blockName, key, blockType, block.getDescriptionId().contains("criticalcrates"));
        templates.put(key, LAMP_ON_TEMPLATE);
        key = "_fireproof";
        ModelTemplate FIREPROOF_TEMPLATE = ModModelProvider.createTemplate(blockName, key, blockType, block.getDescriptionId().contains("criticalcrates"));
        templates.put(key, FIREPROOF_TEMPLATE);
        key = "_slimy";
        ModelTemplate SLIMY_TEMPLATE = ModModelProvider.createTemplate(blockName, key, blockType, block.getDescriptionId().contains("criticalcrates"));
        templates.put(key, SLIMY_TEMPLATE);
        return templates;
    }

    private static ModelTemplate createTemplate(String blockName, String key, String blockType, boolean crate) {
        if (!crate) {
            throw new IllegalArgumentException("Block of " + blockName + " must be a crate from CriticalCrates!");
        }
        if (blockType.equals("glass")) {
            return new ModelTemplate(Optional.of(ModelLocationUtils.decorateItemModelLocation((String)("criticalcrates:" + blockName + key))), Optional.of(key), new TextureSlot[]{TextureSlot.END, TextureSlot.SIDE}).extend().parent((Identifier)ModelTemplates.CUBE_COLUMN.model.get()).renderType("translucent").build();
        }
        return new ModelTemplate(Optional.of(ModelLocationUtils.decorateItemModelLocation((String)("criticalcrates:" + blockName + key))), Optional.of(key), new TextureSlot[]{TextureSlot.END, TextureSlot.SIDE}).extend().parent((Identifier)ModelTemplates.CUBE_COLUMN.model.get()).build();
    }

    private void blockItemWithOverrides(Item item, ItemModelGenerators itemModels) {
        String itemName = IDUtils.getItemID(item);
        itemModels.itemModelOutput.accept(item, (ItemModel.Unbaked)new SelectItemModel.Unbaked(new SelectItemModel.UnbakedSwitch((SelectItemModelProperty)new ItemModelPropertyUtils.CrateDataValue(), List.of(new SelectItemModel.SwitchCase(List.of("resistant"), (ItemModel.Unbaked)new BlockModelWrapper.Unbaked(Identifier.fromNamespaceAndPath((String)"criticalcrates", (String)("block/" + itemName + "_resistant")), Collections.emptyList())), new SelectItemModel.SwitchCase(List.of("lamp"), (ItemModel.Unbaked)new BlockModelWrapper.Unbaked(Identifier.fromNamespaceAndPath((String)"criticalcrates", (String)("block/" + itemName + "_lamp")), Collections.emptyList())), new SelectItemModel.SwitchCase(List.of("fireproof"), (ItemModel.Unbaked)new BlockModelWrapper.Unbaked(Identifier.fromNamespaceAndPath((String)"criticalcrates", (String)("block/" + itemName + "_fireproof")), Collections.emptyList())), new SelectItemModel.SwitchCase(List.of("slimy"), (ItemModel.Unbaked)new BlockModelWrapper.Unbaked(Identifier.fromNamespaceAndPath((String)"criticalcrates", (String)("block/" + itemName + "_slimy")), Collections.emptyList())))), Optional.of(new BlockModelWrapper.Unbaked(Identifier.fromNamespaceAndPath((String)"criticalcrates", (String)("block/" + itemName)), Collections.emptyList()))));
    }
}

