/*
 * Decompiled with CFR 0.152.
 */
package com.criticalpickle.criticalcrates.item;

import com.criticalpickle.criticalcrates.Config;
import com.criticalpickle.criticalcrates.util.EnchantmentUtils;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.jetbrains.annotations.NotNull;

public class PliersItem
extends Item {
    public PliersItem(Item.Properties properties) {
        super(properties);
    }

    public boolean isDamageable(ItemStack stack) {
        return true;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return true;
    }

    @NotNull
    public ItemStack getCraftingRemainder(ItemStack stack) {
        int chanceOfDamage;
        ItemStack copiedStack = stack.copy();
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        ItemEnchantments enchants = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)copiedStack);
        int unbreakingLvl = enchants.getLevel(EnchantmentUtils.getEnchantmentHolder((ResourceKey<Enchantment>)Enchantments.UNBREAKING));
        boolean causeDamage = true;
        if (data != null && ((Boolean)data.copyTag().getBoolean("broken").get()).booleanValue()) {
            return ItemStack.EMPTY;
        }
        if (unbreakingLvl > 0 && (chanceOfDamage = RandomSource.create().nextInt(1 + unbreakingLvl)) != 0) {
            causeDamage = false;
        }
        if (causeDamage) {
            copiedStack.setDamageValue(copiedStack.getDamageValue() + 1);
            if (copiedStack.getDamageValue() >= copiedStack.getMaxDamage()) {
                copiedStack.setDamageValue(copiedStack.getDamageValue() - 1);
                CompoundTag dataTag = new CompoundTag();
                dataTag.putBoolean("broken", true);
                copiedStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)dataTag));
            }
        }
        return copiedStack;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltipDisplay, tooltipAdder, flag);
        if (Config.ADDONS_REMOVABLE.getAsBoolean()) {
            if (flag.hasShiftDown()) {
                tooltipAdder.accept((Component)Component.translatable((String)"tooltip.pliers.shift"));
            } else {
                tooltipAdder.accept((Component)Component.translatable((String)"tooltip.pliers").withStyle(ChatFormatting.GRAY));
            }
        }
    }
}

