/*
 * Decompiled with CFR 0.152.
 */
package com.criticalpickle.criticalcrates.screen;

import com.criticalpickle.criticalcrates.block.entity.CrateBlockEntity;
import com.criticalpickle.criticalcrates.block.entity.GlassCrateBlockEntity;
import com.criticalpickle.criticalcrates.registration.ModMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemStacksResourceHandler;
import net.neoforged.neoforge.transfer.item.ResourceHandlerSlot;

public class CrateMenu
extends AbstractContainerMenu {
    public final CrateBlockEntity blockEntity;
    private final Level level;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 27;

    public CrateMenu(int containerId, Inventory inventory, FriendlyByteBuf extraData) {
        this(containerId, inventory, inventory.player.level().getBlockEntity(extraData.readBlockPos()));
    }

    public CrateMenu(int containerId, Inventory inventory, BlockEntity blockEntity) {
        super(ModMenuTypes.CRATE_MENU.get(), containerId);
        this.blockEntity = (CrateBlockEntity)blockEntity;
        this.level = inventory.player.level();
        this.addStandardInventorySlots((Container)inventory, 8, 84);
        this.addCrateInventory();
    }

    public ItemStack quickMoveStack(Player playerIn, int pIndex) {
        Slot sourceSlot = (Slot)this.slots.get(pIndex);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (pIndex < 36) {
            if (!this.moveItemStackTo(sourceStack, 36, 63, false)) {
                return ItemStack.EMPTY;
            }
        } else if (pIndex < 63) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.out.println("Invalid slotIndex:" + pIndex);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean stillValid(Player player) {
        return CrateMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)this.blockEntity.getBlockState().getBlock());
    }

    private void addCrateInventory() {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot((Slot)new ResourceHandlerSlot((ResourceHandler)this.blockEntity.inventory, (arg_0, arg_1, arg_2) -> ((ItemStacksResourceHandler)this.blockEntity.inventory).set(arg_0, arg_1, arg_2), l + i * 9, 8 + l * 18, 16 + i * 18));
            }
        }
    }

    public void removed(Player player) {
        super.removed(player);
        if (!player.level().isClientSide()) {
            if (this.blockEntity instanceof GlassCrateBlockEntity) {
                player.level().playSound(null, this.blockEntity.getBlockPos(), SoundEvents.COPPER_BREAK, SoundSource.BLOCKS, 0.5f, 1.0f);
            } else {
                player.level().playSound(null, this.blockEntity.getBlockPos(), SoundEvents.BARREL_CLOSE, SoundSource.BLOCKS, 0.5f, 1.0f);
            }
        }
    }
}

