/*
 * Decompiled with CFR 0.152.
 */
package com.criticalpickle.criticalcrates.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.properties.conditional.ConditionalItemModelProperty;
import net.minecraft.client.renderer.item.properties.select.SelectItemModelProperty;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import org.jspecify.annotations.Nullable;

public class ItemModelPropertyUtils {

    public record FireproofProperty() implements ConditionalItemModelProperty
    {
        public static final MapCodec<FireproofProperty> MAP_CODEC = MapCodec.unit((Object)new FireproofProperty());

        public MapCodec<? extends ConditionalItemModelProperty> type() {
            return MAP_CODEC;
        }

        public boolean get(ItemStack itemStack, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity, int i, ItemDisplayContext itemDisplayContext) {
            if (itemStack.getComponents().get(DataComponents.CUSTOM_DATA) != null) {
                CompoundTag dataTag = ((CustomData)itemStack.getComponents().get(DataComponents.CUSTOM_DATA)).copyTag();
                return dataTag.getBooleanOr("fireproof", false);
            }
            return false;
        }
    }

    public record LampProperty() implements ConditionalItemModelProperty
    {
        public static final MapCodec<LampProperty> MAP_CODEC = MapCodec.unit((Object)new LampProperty());

        public MapCodec<? extends ConditionalItemModelProperty> type() {
            return MAP_CODEC;
        }

        public boolean get(ItemStack itemStack, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity, int i, ItemDisplayContext itemDisplayContext) {
            if (itemStack.getComponents().get(DataComponents.CUSTOM_DATA) != null) {
                CompoundTag dataTag = ((CustomData)itemStack.getComponents().get(DataComponents.CUSTOM_DATA)).copyTag();
                return dataTag.getBooleanOr("lamp_upgrade", false);
            }
            return false;
        }
    }

    public record ResistantProperty() implements ConditionalItemModelProperty
    {
        public static final MapCodec<ResistantProperty> MAP_CODEC = MapCodec.unit((Object)new ResistantProperty());

        public MapCodec<? extends ConditionalItemModelProperty> type() {
            return MAP_CODEC;
        }

        public boolean get(ItemStack itemStack, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity, int i, ItemDisplayContext itemDisplayContext) {
            if (itemStack.getComponents().get(DataComponents.CUSTOM_DATA) != null) {
                CompoundTag dataTag = ((CustomData)itemStack.getComponents().get(DataComponents.CUSTOM_DATA)).copyTag();
                return dataTag.getBooleanOr("explosion_resistant", false);
            }
            return false;
        }
    }

    public record CrateDataValue() implements SelectItemModelProperty<String>
    {
        public static final SelectItemModelProperty.Type<CrateDataValue, String> TYPE = SelectItemModelProperty.Type.create((MapCodec)MapCodec.unit((Object)new CrateDataValue()), (Codec)Codec.STRING);

        public @Nullable String get(ItemStack itemStack, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity, int i, ItemDisplayContext itemDisplayContext) {
            if (itemStack.getComponents().get(DataComponents.CUSTOM_DATA) != null) {
                CompoundTag dataTag = ((CustomData)itemStack.getComponents().get(DataComponents.CUSTOM_DATA)).copyTag();
                if (dataTag.getBooleanOr("explosion_resistant", false)) {
                    return "resistant";
                }
                if (dataTag.getBooleanOr("lamp_upgrade", false)) {
                    return "lamp";
                }
                if (dataTag.getBooleanOr("fireproof", false)) {
                    return "fireproof";
                }
                if (dataTag.getBooleanOr("slimy", false)) {
                    return "slimy";
                }
            }
            return "";
        }

        public Codec<String> valueCodec() {
            return Codec.STRING;
        }

        public SelectItemModelProperty.Type<? extends SelectItemModelProperty<String>, String> type() {
            return TYPE;
        }
    }
}

