/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.well_rested.event;

import dev.architectury.event.events.common.TickEvent;
import net.bandit.well_rested.data.PlayerData;
import net.bandit.well_rested.event.StreakDisplayHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class SleepEventHandler {
    public static void register() {
        TickEvent.PLAYER_POST.register(SleepEventHandler::onPlayerTick);
    }

    private static void onPlayerTick(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        PlayerData data = PlayerData.get(serverPlayer);
        if (player.isSleeping() && !data.isSleeping()) {
            player.displayClientMessage((Component)Component.literal((String)"Sleep through the night for rewards!").withStyle(ChatFormatting.YELLOW), true);
            data.setSleeping(true);
        }
        if (!player.isSleeping() && data.isSleeping()) {
            data.setSleeping(false);
            if (player.level().isDay()) {
                data.incrementSleepStreak();
                StreakDisplayHandler.displayStreakEffects(serverPlayer, data.getSleepStreak());
            } else {
                data.resetSleepStreak();
            }
        }
    }
}

