/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.well_rested.event;

import net.bandit.well_rested.config.restedXpConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;

public class StreakDisplayHandler {
    public static void displayStreakEffects(ServerPlayer player, int streak) {
        player.sendSystemMessage((Component)Component.literal((String)("Sleep Streak: " + streak)).withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}), true);
        player.displayClientMessage((Component)Component.literal((String)("You gained: " + StreakDisplayHandler.getStreakRewardText(streak))).withStyle(ChatFormatting.GREEN), true);
        StreakDisplayHandler.spawnStreakParticles(player, streak);
        player.playSound(SoundEvents.PLAYER_LEVELUP, 1.0f, 1.0f + (float)streak * 0.1f);
        StreakDisplayHandler.applySleepRewards(player, streak);
    }

    private static void spawnStreakParticles(ServerPlayer player, int streak) {
        for (int i = 0; i < streak * 10; ++i) {
            double offsetX = (Math.random() - 0.5) * 2.0;
            double offsetY = Math.random() * 2.0;
            double offsetZ = (Math.random() - 0.5) * 2.0;
            player.level().addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, player.getX() + offsetX, player.getY() + offsetY, player.getZ() + offsetZ, 0.0, 0.0, 0.0);
        }
    }

    private static void applySleepRewards(ServerPlayer player, int streak) {
        restedXpConfig.Reward reward = restedXpConfig.configData.streakRewards.getOrDefault(streak, new restedXpConfig.Reward("Absorption", 500 + (streak - 7) * 100));
        if (reward.effect != null) {
            MobEffectInstance effectInstance;
            switch (reward.effect) {
                case "Luck": {
                    MobEffectInstance mobEffectInstance = new MobEffectInstance(MobEffects.LUCK, 6000, 0);
                    break;
                }
                case "Haste": {
                    MobEffectInstance mobEffectInstance = new MobEffectInstance(MobEffects.DIG_SPEED, 6000, 0);
                    break;
                }
                case "Regeneration": {
                    MobEffectInstance mobEffectInstance = new MobEffectInstance(MobEffects.REGENERATION, 6000, 0);
                    break;
                }
                case "Speed": {
                    MobEffectInstance mobEffectInstance = new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 6000, 0);
                    break;
                }
                case "Resistance": {
                    MobEffectInstance mobEffectInstance = new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 6000, 1);
                    break;
                }
                case "Strength": {
                    MobEffectInstance mobEffectInstance = new MobEffectInstance(MobEffects.DAMAGE_BOOST, 6000, 1);
                    break;
                }
                case "Absorption": {
                    MobEffectInstance mobEffectInstance = new MobEffectInstance(MobEffects.ABSORPTION, 6000, Math.min((streak - 7) / 2, 4));
                    break;
                }
                default: {
                    MobEffectInstance mobEffectInstance = effectInstance = null;
                }
            }
            if (effectInstance != null) {
                player.addEffect(effectInstance);
            }
        }
        player.giveExperiencePoints(reward.xp);
    }

    private static String getStreakRewardText(int streak) {
        restedXpConfig.Reward reward = restedXpConfig.configData.streakRewards.getOrDefault(streak, new restedXpConfig.Reward("Extra Buffs", 500 + (streak - 7) * 100));
        if (reward.effect != null) {
            return "+" + reward.effect + ", +" + reward.xp + " XP";
        }
        return "+" + reward.xp + " XP";
    }
}

