/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.rested_xp;

import net.bandit.rested_xp.config.RestedXpConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;

public class StreakDisplayHandler {
    public static void displayStreakEffects(ServerPlayer player, int streak) {
        player.m_240418_((Component)Component.m_237113_((String)("Sleep Streak: " + streak)).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}), true);
        player.m_5661_((Component)Component.m_237113_((String)("You gained: " + StreakDisplayHandler.getStreakRewardText(streak))).m_130940_(ChatFormatting.GREEN), true);
        StreakDisplayHandler.spawnStreakParticles(player, streak);
        player.m_5496_(SoundEvents.f_12275_, 1.0f, 1.0f + (float)streak * 0.1f);
        StreakDisplayHandler.applySleepRewards(player, streak);
    }

    private static void spawnStreakParticles(ServerPlayer player, int streak) {
        for (int i = 0; i < streak * 10; ++i) {
            double offsetX = (Math.random() - 0.5) * 2.0;
            double offsetY = Math.random() * 2.0;
            double offsetZ = (Math.random() - 0.5) * 2.0;
            player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, player.m_20185_() + offsetX, player.m_20186_() + offsetY, player.m_20189_() + offsetZ, 0.0, 0.0, 0.0);
        }
    }

    private static void applySleepRewards(ServerPlayer player, int streak) {
        RestedXpConfig.Reward reward = RestedXpConfig.configData.streakRewards.getOrDefault(streak, new RestedXpConfig.Reward("Absorption", 500 + (streak - 7) * 100));
        if (reward.effect != null) {
            MobEffectInstance effectInstance;
            switch (reward.effect) {
                case "Luck": {
                    MobEffectInstance mobEffectInstance = new MobEffectInstance(MobEffects.f_19621_, 6000, 0);
                    break;
                }
                case "Haste": {
                    MobEffectInstance mobEffectInstance = new MobEffectInstance(MobEffects.f_19598_, 6000, 0);
                    break;
                }
                case "Regeneration": {
                    MobEffectInstance mobEffectInstance = new MobEffectInstance(MobEffects.f_19605_, 6000, 0);
                    break;
                }
                case "Speed": {
                    MobEffectInstance mobEffectInstance = new MobEffectInstance(MobEffects.f_19596_, 6000, 0);
                    break;
                }
                case "Resistance": {
                    MobEffectInstance mobEffectInstance = new MobEffectInstance(MobEffects.f_19606_, 6000, 1);
                    break;
                }
                case "Strength": {
                    MobEffectInstance mobEffectInstance = new MobEffectInstance(MobEffects.f_19600_, 6000, 1);
                    break;
                }
                case "Absorption": {
                    MobEffectInstance mobEffectInstance = new MobEffectInstance(MobEffects.f_19617_, 6000, Math.min((streak - 7) / 2, 4));
                    break;
                }
                default: {
                    MobEffectInstance mobEffectInstance = effectInstance = null;
                }
            }
            if (effectInstance != null) {
                player.m_7292_(effectInstance);
            }
        }
        player.m_6756_(reward.xp);
    }

    private static String getStreakRewardText(int streak) {
        RestedXpConfig.Reward reward = RestedXpConfig.configData.streakRewards.getOrDefault(streak, new RestedXpConfig.Reward("Extra Buffs", 500 + (streak - 7) * 100));
        if (reward.effect != null) {
            return "+" + reward.effect + ", +" + reward.xp + " XP";
        }
        return "+" + reward.xp + " XP";
    }
}

