/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.rested_xp.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.architectury.platform.Platform;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public class RestedXpConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File(Platform.getConfigFolder().toFile(), "rested_xp.json");
    public static ConfigData configData = new ConfigData();

    public static void loadConfig() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                configData = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
            }
            catch (IOException e) {
                System.err.println("Failed to load Rested XP config, using defaults.");
                e.printStackTrace();
            }
        } else {
            RestedXpConfig.saveConfig();
        }
    }

    public static void saveConfig() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)configData, (Appendable)writer);
        }
        catch (IOException e) {
            System.err.println("Failed to save Rested XP config.");
            e.printStackTrace();
        }
    }

    public static class ConfigData {
        public Map<Integer, Reward> streakRewards = new HashMap<Integer, Reward>();

        public ConfigData() {
            this.streakRewards.put(1, new Reward("Luck", 100));
            this.streakRewards.put(2, new Reward("Haste", 200));
            this.streakRewards.put(3, new Reward("Regeneration", 300));
            this.streakRewards.put(4, new Reward("Speed", 500));
            this.streakRewards.put(5, new Reward("Resistance", 1000));
            this.streakRewards.put(6, new Reward(null, 5000));
            this.streakRewards.put(7, new Reward("Strength", 2000));
        }
    }

    public static class Reward {
        public String effect;
        public int xp;

        public Reward(String effect, int xp) {
            this.effect = effect;
            this.xp = xp;
        }
    }
}

