/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.rested_xp;

import net.bandit.rested_xp.config.RestedXpConfig;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;

public class StreakDisplayHandler {
    public static void displayStreakEffects(class_3222 player, int streak) {
        player.method_43502((class_2561)class_2561.method_43470((String)("Sleep Streak: " + streak)).method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), true);
        player.method_7353((class_2561)class_2561.method_43470((String)("You gained: " + StreakDisplayHandler.getStreakRewardText(streak))).method_27692(class_124.field_1060), true);
        StreakDisplayHandler.spawnStreakParticles(player, streak);
        player.method_5783(class_3417.field_14709, 1.0f, 1.0f + (float)streak * 0.1f);
        StreakDisplayHandler.applySleepRewards(player, streak);
    }

    private static void spawnStreakParticles(class_3222 player, int streak) {
        for (int i = 0; i < streak * 10; ++i) {
            double offsetX = (Math.random() - 0.5) * 2.0;
            double offsetY = Math.random() * 2.0;
            double offsetZ = (Math.random() - 0.5) * 2.0;
            player.method_37908().method_8406((class_2394)class_2398.field_11211, player.method_23317() + offsetX, player.method_23318() + offsetY, player.method_23321() + offsetZ, 0.0, 0.0, 0.0);
        }
    }

    private static void applySleepRewards(class_3222 player, int streak) {
        RestedXpConfig.Reward reward = RestedXpConfig.configData.streakRewards.getOrDefault(streak, new RestedXpConfig.Reward("Absorption", 500 + (streak - 7) * 100));
        if (reward.effect != null) {
            class_1293 effectInstance;
            switch (reward.effect) {
                case "Luck": {
                    class_1293 class_12932 = new class_1293(class_1294.field_5926, 6000, 0);
                    break;
                }
                case "Haste": {
                    class_1293 class_12932 = new class_1293(class_1294.field_5917, 6000, 0);
                    break;
                }
                case "Regeneration": {
                    class_1293 class_12932 = new class_1293(class_1294.field_5924, 6000, 0);
                    break;
                }
                case "Speed": {
                    class_1293 class_12932 = new class_1293(class_1294.field_5904, 6000, 0);
                    break;
                }
                case "Resistance": {
                    class_1293 class_12932 = new class_1293(class_1294.field_5907, 6000, 1);
                    break;
                }
                case "Strength": {
                    class_1293 class_12932 = new class_1293(class_1294.field_5910, 6000, 1);
                    break;
                }
                case "Absorption": {
                    class_1293 class_12932 = new class_1293(class_1294.field_5898, 6000, Math.min((streak - 7) / 2, 4));
                    break;
                }
                default: {
                    class_1293 class_12932 = effectInstance = null;
                }
            }
            if (effectInstance != null) {
                player.method_6092(effectInstance);
            }
        }
        player.method_7255(reward.xp);
    }

    private static String getStreakRewardText(int streak) {
        RestedXpConfig.Reward reward = RestedXpConfig.configData.streakRewards.getOrDefault(streak, new RestedXpConfig.Reward("Extra Buffs", 500 + (streak - 7) * 100));
        if (reward.effect != null) {
            return "+" + reward.effect + ", +" + reward.xp + " XP";
        }
        return "+" + reward.xp + " XP";
    }
}

