/*
 * Decompiled with CFR 0.152.
 */
package com.archaeological_research.exploration.addon.arr;

import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface ArrBasket
extends Container {
    public static final VoxelShape[] COLLECTION_AREA_SHAPES = new VoxelShape[]{Block.box((double)0.0, (double)-16.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)-16.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)32.0), Block.box((double)-16.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)32.0, (double)16.0, (double)16.0)};

    default public VoxelShape getFacingCollectionArea(int facingIndex) {
        return COLLECTION_AREA_SHAPES[facingIndex];
    }

    public double getLevelX();

    public double getLevelY();

    public double getLevelZ();

    public void setCooldown(int var1);

    public boolean isOnCooldown();

    public boolean isOnCustomCooldown();

    public void tryTransfer(BooleanSupplier var1);

    default public boolean collectItems(Level level, int facingIndex) {
        for (ItemEntity itementity : this.getItemsToCollect(level, facingIndex)) {
            if (!this.collectItem(itementity)) continue;
            return true;
        }
        return false;
    }

    default public List<ItemEntity> getItemsToCollect(Level level, int facingIndex) {
        return this.getFacingCollectionArea(facingIndex).toAabbs().stream().flatMap(aabb -> level.getEntitiesOfClass(ItemEntity.class, aabb.move(this.getLevelX() - 0.5, this.getLevelY() - 0.5, this.getLevelZ() - 0.5), EntitySelector.ENTITY_STILL_ALIVE).stream()).collect(Collectors.toList());
    }

    default public boolean collectItem(ItemEntity itemEntity) {
        boolean flag = false;
        ItemStack entityItemStack = itemEntity.getItem().copy();
        ItemStack remainderStack = this.insert(entityItemStack);
        if (remainderStack.isEmpty()) {
            flag = true;
            itemEntity.discard();
        } else {
            itemEntity.setItem(remainderStack);
        }
        return flag;
    }

    default public ItemStack insert(ItemStack stack) {
        int size = this.getContainerSize();
        for (int slot = 0; slot < size && !stack.isEmpty(); ++slot) {
            stack = this.insert(slot, stack);
        }
        return stack;
    }

    default public ItemStack insert(int slot, ItemStack stack) {
        ItemStack slotStack = this.getItem(slot);
        if (this.canPlaceItem(slot, stack)) {
            boolean inserted = false;
            if (slotStack.isEmpty()) {
                this.setItem(slot, stack);
                stack = ItemStack.EMPTY;
                inserted = true;
            } else if (ArrBasket.canMergeItems(slotStack, stack)) {
                int insertCount = stack.getMaxStackSize() - slotStack.getCount();
                insertCount = Math.min(stack.getCount(), insertCount);
                stack.shrink(insertCount);
                slotStack.grow(insertCount);
                boolean bl = inserted = insertCount > 0;
            }
            if (inserted) {
                if (this.isEmpty() && !this.isOnCustomCooldown()) {
                    this.setCooldown(8);
                }
                this.setChanged();
            }
        }
        return stack;
    }

    public static boolean canMergeItems(ItemStack stack1, ItemStack stack2) {
        return stack1.getCount() <= stack1.getMaxStackSize() && ItemStack.isSameItemSameComponents((ItemStack)stack1, (ItemStack)stack2);
    }
}

