/*
 * Decompiled with CFR 0.152.
 */
package com.archaeological_research.exploration.addon.arr;

import com.archaeological_research.exploration.addon.arr.ArrBrushableBE;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;

public abstract class ArrBrushItem
extends Item {
    private static final int ANIMATION_DURATION = 4;
    private static final int USE_DURATION = 80;
    protected final int brushLevel;

    public ArrBrushItem(Item.Properties properties, int brushLevel) {
        super(properties);
        this.brushLevel = brushLevel;
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player != null && this.calculateHitResult(player).getType() == HitResult.Type.BLOCK) {
            player.startUsingItem(context.getHand());
        }
        return InteractionResult.CONSUME;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BRUSH;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 80;
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        if (remainingUseDuration >= 0 && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            HitResult hitresult = this.calculateHitResult(player);
            if (hitresult instanceof BlockHitResult) {
                BlockHitResult blockhitresult = (BlockHitResult)hitresult;
                if (hitresult.getType() == HitResult.Type.BLOCK) {
                    boolean flag;
                    int i = this.getUseDuration(stack, livingEntity) - remainingUseDuration + 1;
                    boolean bl = flag = i % 10 == 5;
                    if (flag) {
                        BlockEntity flag12;
                        EquipmentSlot equipmentslot;
                        boolean flag12;
                        ArrBrushableBE brushableBlockEntity;
                        SoundEvent soundevent;
                        Block block;
                        HumanoidArm humanoidarm;
                        BlockPos blockpos = blockhitresult.getBlockPos();
                        BlockState blockstate = level.getBlockState(blockpos);
                        HumanoidArm humanoidArm = humanoidarm = livingEntity.getUsedItemHand() == InteractionHand.MAIN_HAND ? player.getMainArm() : player.getMainArm().getOpposite();
                        if (blockstate.shouldSpawnTerrainParticles() && blockstate.getRenderShape() != RenderShape.INVISIBLE) {
                            this.spawnDustParticles(level, blockhitresult, blockstate, livingEntity.getViewVector(0.0f), humanoidarm);
                        }
                        if ((block = blockstate.getBlock()) instanceof BrushableBlock) {
                            BrushableBlock brushableblock = (BrushableBlock)block;
                            soundevent = brushableblock.getBrushSound();
                        } else {
                            soundevent = SoundEvents.BRUSH_GENERIC;
                        }
                        level.playSound(player, blockpos, soundevent, SoundSource.BLOCKS);
                        if (!level.isClientSide() && (block = level.getBlockEntity(blockpos)) instanceof ArrBrushableBE && (brushableBlockEntity = (ArrBrushableBE)block).getBrushLevel() <= this.getBrushLevel() && (flag12 = brushableBlockEntity.brush(level.getGameTime(), player, blockhitresult.getDirection(), 6 - this.getBrushLevel()))) {
                            equipmentslot = stack.equals(player.getItemBySlot(EquipmentSlot.OFFHAND)) ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
                            stack.hurtAndBreak(1, livingEntity, equipmentslot);
                        }
                        if (!level.isClientSide() && (flag12 = level.getBlockEntity(blockpos)) instanceof BrushableBlockEntity && (flag1 = (brushableBlockEntity = (BrushableBlockEntity)flag12).brush(level.getGameTime(), player, blockhitresult.getDirection()))) {
                            equipmentslot = stack.equals(player.getItemBySlot(EquipmentSlot.OFFHAND)) ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
                            stack.hurtAndBreak(1, livingEntity, equipmentslot);
                        }
                    }
                    return;
                }
            }
            livingEntity.releaseUsingItem();
        } else {
            livingEntity.releaseUsingItem();
        }
    }

    private int getBrushLevel() {
        int level = this.brushLevel;
        if (level > 0 && level > 7) {
            return 6;
        }
        return level;
    }

    private HitResult calculateHitResult(Player player) {
        return ProjectileUtil.getHitResultOnViewVector((Entity)player, p_281111_ -> !p_281111_.isSpectator() && p_281111_.isPickable(), (double)player.blockInteractionRange());
    }

    private void spawnDustParticles(Level level, BlockHitResult hitResult, BlockState state, Vec3 pos, HumanoidArm arm) {
        double d0 = 3.0;
        int i = arm == HumanoidArm.RIGHT ? 1 : -1;
        int j = level.getRandom().nextInt(7, 12);
        BlockParticleOption blockparticleoption = new BlockParticleOption(ParticleTypes.BLOCK, state);
        Direction direction = hitResult.getDirection();
        DustParticlesDelta BrushItemAPI$dustparticlesdelta = DustParticlesDelta.fromDirection(pos, direction);
        Vec3 vec3 = hitResult.getLocation();
        for (int k = 0; k < j; ++k) {
            level.addParticle((ParticleOptions)blockparticleoption, vec3.x - (double)(direction == Direction.WEST ? 1.0E-6f : 0.0f), vec3.y, vec3.z - (double)(direction == Direction.NORTH ? 1.0E-6f : 0.0f), BrushItemAPI$dustparticlesdelta.xd() * (double)i * 3.0 * level.getRandom().nextDouble(), 0.0, BrushItemAPI$dustparticlesdelta.zd() * (double)i * 3.0 * level.getRandom().nextDouble());
        }
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return ItemAbilities.DEFAULT_BRUSH_ACTIONS.contains(itemAbility);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.archaeological_research_exploration.brushable_block.tooltip.brush_level", (Object[])new Object[]{this.brushLevel}).withStyle(ChatFormatting.GOLD));
    }

    record DustParticlesDelta(double xd, double yd, double zd) {
        private static final double ALONG_SIDE_DELTA = 1.0;
        private static final double OUT_FROM_SIDE_DELTA = 0.1;

        public static DustParticlesDelta fromDirection(Vec3 pos, Direction direction) {
            double d0 = 0.0;
            return switch (direction) {
                default -> throw new MatchException(null, null);
                case Direction.DOWN, Direction.UP -> new DustParticlesDelta(pos.z(), 0.0, -pos.x());
                case Direction.NORTH -> new DustParticlesDelta(1.0, 0.0, -0.1);
                case Direction.SOUTH -> new DustParticlesDelta(-1.0, 0.0, 0.1);
                case Direction.WEST -> new DustParticlesDelta(-0.1, 0.0, -1.0);
                case Direction.EAST -> new DustParticlesDelta(0.1, 0.0, 1.0);
            };
        }
    }
}

