/*
 * Decompiled with CFR 0.152.
 */
package com.archaeological_research.exploration.addon.arr;

import com.archaeological_research.exploration.addon.arr.ArrBrushableBE;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootTable;

public abstract class ArrBrushableB
extends BaseEntityBlock {
    public static final IntegerProperty DUSTED = BlockStateProperties.DUSTED;
    public static final IntegerProperty BLOCK_LEVEL = IntegerProperty.create((String)"block_level", (int)1, (int)5);
    public static final int TICK_DELAY = 2;
    private final Block turnsInto;
    private final SoundEvent brushSound;
    private final SoundEvent brushCompletedSound;
    @Nullable
    private final ResourceKey<LootTable> lootTable;
    protected final int brushLevel;

    public ArrBrushableB(Block turnsInto, SoundEvent brushSound, SoundEvent brushCompletedSound, BlockBehaviour.Properties properties, @Nullable ResourceKey<LootTable> lootTable, int blockLevel) {
        super(properties);
        this.turnsInto = turnsInto;
        this.brushSound = brushSound;
        this.brushCompletedSound = brushCompletedSound;
        this.lootTable = lootTable;
        this.brushLevel = blockLevel;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DUSTED, (Comparable)Integer.valueOf(0))).setValue((Property)BLOCK_LEVEL, (Comparable)Integer.valueOf(blockLevel)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{DUSTED, BLOCK_LEVEL});
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        pLevel.scheduleTick(pPos, (Block)this, 2);
    }

    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        pLevel.scheduleTick(pPos, (Block)this, 2);
        return super.updateShape(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof ArrBrushableBE) {
            ArrBrushableBE blockEntity2 = (ArrBrushableBE)blockEntity;
            blockEntity2.setLootTable(this.lootTable, pPos.asLong());
            blockEntity2.setBrushLevel(Math.min(this.brushLevel, 5));
            blockEntity2.checkReset();
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockPos blockpos;
        if (random.nextInt(16) == 0 && FallingBlock.isFree((BlockState)level.getBlockState(blockpos = pos.below()))) {
            double d0 = (double)pos.getX() + random.nextDouble();
            double d1 = (double)pos.getY() - 0.05;
            double d2 = (double)pos.getZ() + random.nextDouble();
            level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.FALLING_DUST, state), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public abstract BlockEntity newBlockEntity(BlockPos var1, BlockState var2);

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        pTooltipComponents.add((Component)Component.translatable((String)"item.archaeological_research_exploration.brushable_block.tooltip.brush_level", (Object[])new Object[]{this.brushLevel}).withStyle(ChatFormatting.GOLD));
    }

    public Block getTurnsInto() {
        return this.turnsInto;
    }
}

