/*
 * Decompiled with CFR 0.152.
 */
package com.archaeological_research.exploration.addon.arr;

import com.archaeological_research.exploration.blocks.recipe.AirDryingRB;
import com.archaeological_research.exploration.blocks.recipe.CuttingRB;
import com.archaeological_research.exploration.blocks.recipe.DryingRB;
import com.archaeological_research.exploration.blocks.recipe.ForgingRB;
import com.archaeological_research.exploration.blocks.recipe.GrillingRB;
import com.archaeological_research.exploration.blocks.recipe.GrindingRB;
import com.archaeological_research.exploration.blocks.recipe.GrowingRB;
import com.archaeological_research.exploration.blocks.recipe.NegentropyRB;
import com.archaeological_research.exploration.blocks.recipe.SievingRB;
import com.archaeological_research.exploration.blocks.recipe.SoakingRB;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public abstract class ArrRecipeProvider
extends RecipeProvider {
    public static final ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"archaeological_research_exploration", (String)"recipe/");

    public ArrRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    public void buildCuttingRecipe(RecipeOutput output, ItemLike input, ItemLike result, int count, int cookingTime) {
        Ingredient ingredient = Ingredient.of((ItemLike[])new ItemLike[]{input});
        new CuttingRB(ingredient, result.asItem(), count, cookingTime).unlockedBy(input.toString(), ArrRecipeProvider.has((ItemLike)input)).save(output, String.valueOf(location) + ArrRecipeProvider.getItemName((ItemLike)result) + "_with_" + ArrRecipeProvider.getItemName((ItemLike)input));
    }

    public void buildSievingRecipe(RecipeOutput output, ItemLike input, ItemLike result, int count, int cookingTime) {
        Ingredient ingredient = Ingredient.of((ItemLike[])new ItemLike[]{input});
        new SievingRB(ingredient, result.asItem(), count, cookingTime).unlockedBy(input.toString(), ArrRecipeProvider.has((ItemLike)input)).save(output, String.valueOf(location) + ArrRecipeProvider.getItemName((ItemLike)result) + "_with_" + ArrRecipeProvider.getItemName((ItemLike)input));
    }

    public void buildForgingRecipe(RecipeOutput output, ItemLike input, ItemLike result, int count, int cookingTime) {
        Ingredient ingredient = Ingredient.of((ItemLike[])new ItemLike[]{input});
        new ForgingRB(ingredient, result.asItem(), count, cookingTime).unlockedBy(input.toString(), ArrRecipeProvider.has((ItemLike)input)).save(output, String.valueOf(location) + ArrRecipeProvider.getItemName((ItemLike)result) + "_with_" + ArrRecipeProvider.getItemName((ItemLike)input));
    }

    public void buildGrindingRecipe(RecipeOutput output, ItemLike input, ItemLike result, int count, int cookingTime) {
        Ingredient ingredient = Ingredient.of((ItemLike[])new ItemLike[]{input});
        new GrindingRB(ingredient, result.asItem(), count, cookingTime).unlockedBy(input.toString(), ArrRecipeProvider.has((ItemLike)input)).save(output, String.valueOf(location) + ArrRecipeProvider.getItemName((ItemLike)result) + "_with_" + ArrRecipeProvider.getItemName((ItemLike)input));
    }

    public void buildAirDryingRecipe(RecipeOutput output, ItemLike input, ItemLike result, int count, int cookingTime) {
        Ingredient ingredient = Ingredient.of((ItemLike[])new ItemLike[]{input});
        new AirDryingRB(ingredient, result.asItem(), count, cookingTime).unlockedBy(input.toString(), ArrRecipeProvider.has((ItemLike)input)).save(output, String.valueOf(location) + ArrRecipeProvider.getItemName((ItemLike)result) + "_with_" + ArrRecipeProvider.getItemName((ItemLike)input));
    }

    public void buildDryingRecipe(RecipeOutput output, ItemLike input, ItemLike result, int count, int cookingTime) {
        Ingredient ingredient = Ingredient.of((ItemLike[])new ItemLike[]{input});
        new DryingRB(ingredient, result.asItem(), count, cookingTime).unlockedBy(input.toString(), ArrRecipeProvider.has((ItemLike)input)).save(output, String.valueOf(location) + ArrRecipeProvider.getItemName((ItemLike)result) + "_with_" + ArrRecipeProvider.getItemName((ItemLike)input));
    }

    public void buildGrillingRecipe(RecipeOutput output, ItemLike input, ItemLike result, int count, int cookingTime) {
        Ingredient ingredient = Ingredient.of((ItemLike[])new ItemLike[]{input});
        new GrillingRB(ingredient, result.asItem(), count, cookingTime).unlockedBy(input.toString(), ArrRecipeProvider.has((ItemLike)input)).save(output, String.valueOf(location) + ArrRecipeProvider.getItemName((ItemLike)result) + "_with_" + ArrRecipeProvider.getItemName((ItemLike)input));
    }

    public void buildSoakingRecipe(RecipeOutput output, ItemLike input, ItemLike result, int count, int cookingTime) {
        Ingredient ingredient = Ingredient.of((ItemLike[])new ItemLike[]{input});
        new SoakingRB(ingredient, result.asItem(), count, cookingTime).unlockedBy(input.toString(), ArrRecipeProvider.has((ItemLike)input)).save(output, String.valueOf(location) + ArrRecipeProvider.getItemName((ItemLike)result) + "_with_" + ArrRecipeProvider.getItemName((ItemLike)input));
    }

    public void buildGrowingRecipe(RecipeOutput output, ItemLike input, ItemLike input2, ItemLike result, int count, int cookingTime) {
        Ingredient ingredient = Ingredient.of((ItemLike[])new ItemLike[]{input, input2});
        new GrowingRB(ingredient, result.asItem(), count, cookingTime).unlockedBy(input.toString(), ArrRecipeProvider.has((ItemLike)input)).save(output, String.valueOf(location) + ArrRecipeProvider.getItemName((ItemLike)result) + "_with_" + ArrRecipeProvider.getItemName((ItemLike)input2));
    }

    public void buildSacrificingRecipe(RecipeOutput output, ItemLike input, ItemLike result, int count, int cookingTime) {
        Ingredient ingredient = Ingredient.of((ItemLike[])new ItemLike[]{input});
        new NegentropyRB(ingredient, result.asItem(), count, cookingTime).unlockedBy(input.toString(), ArrRecipeProvider.has((ItemLike)input)).save(output, String.valueOf(location) + ArrRecipeProvider.getItemName((ItemLike)result) + "_with_" + ArrRecipeProvider.getItemName((ItemLike)input));
    }

    public void build_2x2_ShapedRecipe(RecipeOutput output, ItemLike input1, ItemLike input2, ItemLike result, ItemLike need) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).define(Character.valueOf('Q'), input1).define(Character.valueOf('G'), input2).unlockedBy(ArrRecipeProvider.getHasName((ItemLike)need), ArrRecipeProvider.has((ItemLike)need)).pattern("GQ").pattern("QG").save(output);
    }

    public void build_2_ShapedRecipe(RecipeOutput output, ItemLike input1, ItemLike input2, ItemLike result, ItemLike need) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).define(Character.valueOf('Q'), input1).define(Character.valueOf('G'), input2).unlockedBy(ArrRecipeProvider.getHasName((ItemLike)need), ArrRecipeProvider.has((ItemLike)need)).pattern("QG").save(output);
    }

    public void build_3_ShapedRecipe(RecipeOutput output, ItemLike input1, ItemLike input2, ItemLike input3, ItemLike result) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).define(Character.valueOf('Q'), input1).define(Character.valueOf('G'), input2).define(Character.valueOf('H'), input3).unlockedBy(ArrRecipeProvider.getHasName((ItemLike)input1), ArrRecipeProvider.has((ItemLike)input1)).pattern("QGH").save(output);
    }

    public void build_2I_ShapedRecipe(RecipeOutput output, ItemLike input1, ItemLike input2, ItemLike result, ItemLike need) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).define(Character.valueOf('Q'), input1).define(Character.valueOf('G'), input2).unlockedBy(ArrRecipeProvider.getHasName((ItemLike)need), ArrRecipeProvider.has((ItemLike)need)).pattern("G").pattern("Q").save(output);
    }

    public void build_2I2_ShapedRecipe(RecipeOutput output, ItemLike input1, ItemLike input2, ItemLike result, ItemLike need) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).define(Character.valueOf('Q'), input1).define(Character.valueOf('G'), input2).unlockedBy(ArrRecipeProvider.getHasName((ItemLike)need), ArrRecipeProvider.has((ItemLike)need)).pattern("GG").pattern("QQ").save(output);
    }

    public void build_3I_ShapedRecipe(RecipeOutput output, ItemLike input1, ItemLike input2, ItemLike input3, ItemLike result, ItemLike need) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).define(Character.valueOf('Q'), input1).define(Character.valueOf('G'), input2).define(Character.valueOf('H'), input3).unlockedBy(ArrRecipeProvider.getHasName((ItemLike)need), ArrRecipeProvider.has((ItemLike)need)).pattern("H").pattern("G").pattern("Q").save(output);
    }

    public void build_3x3C_ShapedRecipe(RecipeOutput output, ItemLike input1, ItemLike input2, ItemLike input3, ItemLike result, ItemLike need) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).define(Character.valueOf('Q'), input1).define(Character.valueOf('G'), input2).define(Character.valueOf('H'), input3).unlockedBy(ArrRecipeProvider.getHasName((ItemLike)need), ArrRecipeProvider.has((ItemLike)need)).pattern("QGQ").pattern("GHG").pattern("QGQ").save(output);
    }

    public void build_3x3N_ShapedRecipe(RecipeOutput output, ItemLike input1, ItemLike input2, ItemLike result, ItemLike need) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).define(Character.valueOf('Q'), input1).define(Character.valueOf('G'), input2).unlockedBy(ArrRecipeProvider.getHasName((ItemLike)need), ArrRecipeProvider.has((ItemLike)need)).pattern("QGQ").pattern("G G").pattern("QGQ").save(output);
    }

    public void build_3x3_ShapedRecipe(RecipeOutput output, ItemLike input1, ItemLike input2, ItemLike input3, ItemLike input4, ItemLike result, ItemLike need) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).define(Character.valueOf('Q'), input1).define(Character.valueOf('G'), input2).define(Character.valueOf('B'), input3).define(Character.valueOf('H'), input4).unlockedBy(ArrRecipeProvider.getHasName((ItemLike)need), ArrRecipeProvider.has((ItemLike)need)).pattern("QBQ").pattern("GHG").pattern("QBQ").save(output);
    }

    public void build_3v3_ShapedRecipe(RecipeOutput output, ItemLike input1, ItemLike input2, ItemLike input3, ItemLike result, int count) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)count).define(Character.valueOf('Q'), input1).define(Character.valueOf('G'), input2).define(Character.valueOf('H'), input3).unlockedBy(ArrRecipeProvider.getHasName((ItemLike)input3), ArrRecipeProvider.has((ItemLike)input3)).pattern(" G ").pattern("QHQ").pattern(" G ").save(output);
    }

    public void build_2_ShapelessRecipe(RecipeOutput output, ItemLike input1, ItemLike input2, ItemLike result) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).requires(input1).requires(input2).unlockedBy(ArrRecipeProvider.getHasName((ItemLike)input1), ArrRecipeProvider.has((ItemLike)input1)).save(output);
    }

    public static void oreSmelting(RecipeOutput recipeOutput, List<ItemLike> ingredients, RecipeCategory category, ItemLike result, ItemLike result1, float experience, int cookingTime, String group) {
        ArrRecipeProvider.oreCooking(recipeOutput, RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, ingredients, category, result, result1, experience, cookingTime, group, "_from_smelting");
    }

    public static void oreBlasting(RecipeOutput recipeOutput, List<ItemLike> ingredients, RecipeCategory category, ItemLike result, ItemLike result1, float experience, int cookingTime, String group) {
        ArrRecipeProvider.oreCooking(recipeOutput, RecipeSerializer.BLASTING_RECIPE, BlastingRecipe::new, ingredients, category, result, result1, experience, cookingTime, group, "_from_blasting");
    }

    public static <T extends AbstractCookingRecipe> void oreCooking(RecipeOutput recipeOutput, RecipeSerializer<T> serializer, AbstractCookingRecipe.Factory<T> recipeFactory, List<ItemLike> ingredients, RecipeCategory category, ItemLike result, ItemLike result1, float experience, int cookingTime, String group, String suffix) {
        for (ItemLike itemlike : ingredients) {
            SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{itemlike}), (RecipeCategory)category, (ItemLike)result, (float)experience, (int)cookingTime, serializer, recipeFactory).group(group).unlockedBy(ArrRecipeProvider.getHasName((ItemLike)itemlike), ArrRecipeProvider.has((ItemLike)itemlike)).save(recipeOutput, ArrRecipeProvider.getItemName((ItemLike)result1) + suffix + "_" + ArrRecipeProvider.getItemName((ItemLike)itemlike));
        }
    }

    public static void smithing(RecipeOutput output, ItemLike base, ItemLike item, ItemLike result, String id) {
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{base}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{item}), (RecipeCategory)RecipeCategory.TOOLS, (Item)result.asItem()).unlocks(ArrRecipeProvider.getHasName((ItemLike)item), ArrRecipeProvider.has((ItemLike)item)).save(output, id);
    }

    public static void familyBuilder(RecipeOutput output, ItemLike base, ItemLike slab, ItemLike stair, ItemLike wall, ItemLike fence, ItemLike fenceGate) {
        ArrRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slab, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{base})).unlockedBy(ArrRecipeProvider.getHasName((ItemLike)base), ArrRecipeProvider.has((ItemLike)Blocks.PURPUR_BLOCK)).save(output);
        ArrRecipeProvider.stairBuilder((ItemLike)stair, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{base})).unlockedBy(ArrRecipeProvider.getHasName((ItemLike)base), ArrRecipeProvider.has((ItemLike)Blocks.PURPUR_BLOCK)).save(output);
        ArrRecipeProvider.wall((RecipeOutput)output, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)wall, (ItemLike)base);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)fence, (int)3).define(Character.valueOf('W'), base).define(Character.valueOf('#'), (ItemLike)Items.STICK).pattern("W#W").pattern("W#W").unlockedBy(ArrRecipeProvider.getHasName((ItemLike)base), ArrRecipeProvider.has((ItemLike)base)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)fenceGate).define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('W'), base).pattern("#W#").pattern("#W#").unlockedBy(ArrRecipeProvider.getHasName((ItemLike)base), ArrRecipeProvider.has((ItemLike)base)).save(output);
    }

    public static void logBuilder(RecipeOutput output, ItemLike planks, ItemLike log, ItemLike wood, String id) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)planks, (int)4).requires(log).unlockedBy(ArrRecipeProvider.getHasName((ItemLike)log), ArrRecipeProvider.has((ItemLike)log)).save(output, id);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)planks, (int)4).requires(wood).unlockedBy(ArrRecipeProvider.getHasName((ItemLike)wood), ArrRecipeProvider.has((ItemLike)wood)).save(output);
        ArrRecipeProvider.woodFromLogs((RecipeOutput)output, (ItemLike)wood, (ItemLike)Blocks.CHERRY_LOG);
    }
}

