/*
 * Decompiled with CFR 0.152.
 */
package com.archaeological_research.exploration.addon.jei;

import com.archaeological_research.exploration.blocks.recipe.GrindingRecipe;
import com.archaeological_research.exploration.register.ModBlocks;
import com.archaeological_research.exploration.register.ModItems;
import java.text.NumberFormat;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.placement.HorizontalAlignment;
import mezz.jei.api.gui.placement.VerticalAlignment;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.ITextWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class JeiGrindingCategory
implements IRecipeCategory<GrindingRecipe> {
    private static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"archaeological_research_exploration", (String)"grinding");
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jei", (String)"textures/jei/gui/debug.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;
    public static final RecipeType<GrindingRecipe> RECIPE_TYPE = new RecipeType(UID, GrindingRecipe.class);

    public JeiGrindingCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 114, 61);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(ModBlocks.STONE_HAND_PUSHED_MILLSTONE));
        this.arrow = guiHelper.createAnimatedRecipeArrow(200);
    }

    public RecipeType<GrindingRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"recipe.archaeological_research_exploration.grinding");
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, GrindingRecipe recipe, IFocusGroup focuses) {
        builder.addInputSlot(2, 20).setStandardSlotBackground().addIngredients((Ingredient)recipe.getIngredients().getFirst());
        builder.addInputSlot(24, 20).setStandardSlotBackground().addItemStack(((SwordItem)ModItems.POLISHED_KNIFE.get()).getDefaultInstance());
        builder.addOutputSlot(81, 20).setOutputSlotBackground().addItemStack(recipe.getResultItem(null));
    }

    public static Component createSmeltCountText(int progress) {
        NumberFormat numberInstance = NumberFormat.getNumberInstance();
        String processCount = numberInstance.format(progress);
        return Component.translatable((String)"gui.archaeological_research_exploration.category.grinding_progress", (Object[])new Object[]{processCount});
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, GrindingRecipe recipe, IFocusGroup focuses) {
        int progress = recipe.progress();
        Component smeltCountText = JeiGrindingCategory.createSmeltCountText(progress);
        ((ITextWidget)builder.addText((FormattedText)smeltCountText, this.getWidth() - 20, this.getHeight()).setPosition(20, 20)).setTextAlignment(HorizontalAlignment.CENTER).setTextAlignment(VerticalAlignment.CENTER).setColor(-8355712);
    }

    public void draw(GrindingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        this.background.draw(guiGraphics);
        this.arrow.draw(guiGraphics, 46, 20);
    }
}

