/*
 * Decompiled with CFR 0.152.
 */
package com.archaeological_research.exploration.addon.jei;

import com.archaeological_research.exploration.blocks.recipe.GrowingRecipe;
import com.archaeological_research.exploration.register.ModBlocks;
import java.text.NumberFormat;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.placement.HorizontalAlignment;
import mezz.jei.api.gui.placement.VerticalAlignment;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.ITextWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class JeiGrowingCategory
implements IRecipeCategory<GrowingRecipe> {
    private static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"archaeological_research_exploration", (String)"growing");
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jei", (String)"textures/jei/gui/debug.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;
    public static final RecipeType<GrowingRecipe> RECIPE_TYPE = new RecipeType(UID, GrowingRecipe.class);

    public JeiGrowingCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 114, 61);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(ModBlocks.BAMBOO_GROWING_SHELF));
        this.arrow = guiHelper.createAnimatedRecipeArrow(200);
    }

    public RecipeType<GrowingRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"recipe.archaeological_research_exploration.growing");
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, GrowingRecipe recipe, IFocusGroup focuses) {
        builder.addInputSlot(2, 20).setStandardSlotBackground().addItemStack(((Ingredient)recipe.getIngredients().getFirst()).getItems()[0]);
        builder.addInputSlot(24, 20).setStandardSlotBackground().addItemStack(((Ingredient)recipe.getIngredients().getFirst()).getItems()[1]);
        builder.addOutputSlot(81, 20).setOutputSlotBackground().addItemStack(recipe.getResultItem(null));
    }

    public static Component createSmeltCountText(int progress) {
        NumberFormat numberInstance = NumberFormat.getNumberInstance();
        String processCount = numberInstance.format(progress);
        return Component.translatable((String)"gui.archaeological_research_exploration.category.growing_progress", (Object[])new Object[]{processCount});
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, GrowingRecipe recipe, IFocusGroup focuses) {
        int progress = recipe.progress();
        Component smeltCountText = JeiGrowingCategory.createSmeltCountText(progress / 20);
        ((ITextWidget)builder.addText((FormattedText)smeltCountText, this.getWidth() - 20, this.getHeight()).setPosition(20, 20)).setTextAlignment(HorizontalAlignment.CENTER).setTextAlignment(VerticalAlignment.CENTER).setColor(-8355712);
    }

    public void draw(GrowingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        this.background.draw(guiGraphics);
        this.arrow.draw(guiGraphics, 46, 20);
    }
}

