/*
 * Decompiled with CFR 0.152.
 */
package com.archaeological_research.exploration.blocks.bamboo;

import com.archaeological_research.exploration.blocks.bamboo.BambooAirDryingRackB;
import com.archaeological_research.exploration.blocks.bamboo.BambooAirDryingRackBE;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;

public class BambooAirDryingRackBER
implements BlockEntityRenderer<BambooAirDryingRackBE> {
    private static final float SIZE = 0.265f;
    private final ItemRenderer itemRenderer;

    public BambooAirDryingRackBER(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.getItemRenderer();
    }

    public void render(BambooAirDryingRackBE blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Direction facing = (Direction)blockEntity.getBlockState().getValue((Property)BambooAirDryingRackB.FACING);
        NonNullList<ItemStack> nonnulllist = blockEntity.getItems();
        int i = (int)blockEntity.getBlockPos().asLong();
        for (int j = 0; j < nonnulllist.size(); ++j) {
            ItemStack itemstack = (ItemStack)nonnulllist.get(j);
            if (itemstack == ItemStack.EMPTY) continue;
            poseStack.pushPose();
            poseStack.translate(0.5f, 0.92f, 0.5f);
            float f = -facing.toYRot();
            if (facing == Direction.WEST) {
                poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
            }
            if (facing == Direction.NORTH) {
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            }
            if (facing == Direction.SOUTH) {
                poseStack.mulPose(Axis.YP.rotationDegrees(f));
            }
            if (facing == Direction.EAST) {
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            }
            poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
            Vec2 vec2 = blockEntity.getRotation(j);
            poseStack.translate(vec2.x, vec2.y, 0.0f);
            poseStack.scale(0.265f, 0.265f, 0.265f);
            this.itemRenderer.renderStatic(itemstack, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, blockEntity.getLevel(), i + j);
            poseStack.popPose();
        }
    }
}

