/*
 * Decompiled with CFR 0.152.
 */
package com.archaeological_research.exploration.blocks.bamboo;

import com.archaeological_research.exploration.blocks.bamboo.BambooBasketBE;
import com.archaeological_research.exploration.register.ModBlockEntities;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BambooBasketB
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<BambooBasketB> CODEC = BambooBasketB.simpleCodec(BambooBasketB::new);
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final BooleanProperty ENABLED = BlockStateProperties.ENABLED;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape[])new VoxelShape[0]);
    public static final ImmutableMap<Direction, VoxelShape> SHAPE_FACING = Maps.immutableEnumMap((Map)ImmutableMap.builder().put((Object)Direction.DOWN, (Object)Shapes.join((VoxelShape)BambooBasketB.box((double)1.0, (double)8.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), (VoxelShape)BambooBasketB.box((double)3.0, (double)8.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0), (BooleanOp)BooleanOp.ONLY_FIRST)).put((Object)Direction.UP, (Object)Shapes.join((VoxelShape)BambooBasketB.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)BambooBasketB.box((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0), (BooleanOp)BooleanOp.ONLY_FIRST)).put((Object)Direction.NORTH, (Object)Shapes.join((VoxelShape)BambooBasketB.box((double)1.0, (double)1.0, (double)8.0, (double)15.0, (double)15.0, (double)16.0), (VoxelShape)BambooBasketB.box((double)3.0, (double)3.0, (double)8.0, (double)13.0, (double)13.0, (double)14.0), (BooleanOp)BooleanOp.ONLY_FIRST)).put((Object)Direction.SOUTH, (Object)Shapes.join((VoxelShape)BambooBasketB.box((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)8.0), (VoxelShape)BambooBasketB.box((double)3.0, (double)3.0, (double)2.0, (double)13.0, (double)13.0, (double)8.0), (BooleanOp)BooleanOp.ONLY_FIRST)).put((Object)Direction.WEST, (Object)Shapes.join((VoxelShape)BambooBasketB.box((double)8.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0), (VoxelShape)BambooBasketB.box((double)8.0, (double)3.0, (double)3.0, (double)14.0, (double)13.0, (double)13.0), (BooleanOp)BooleanOp.ONLY_FIRST)).put((Object)Direction.EAST, (Object)Shapes.join((VoxelShape)BambooBasketB.box((double)0.0, (double)1.0, (double)1.0, (double)8.0, (double)15.0, (double)15.0), (VoxelShape)BambooBasketB.box((double)2.0, (double)3.0, (double)3.0, (double)8.0, (double)13.0, (double)13.0), (BooleanOp)BooleanOp.ONLY_FIRST)).build());

    public BambooBasketB(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (VoxelShape)SHAPE_FACING.get((Object)state.getValue((Property)FACING));
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return SHAPE;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, ENABLED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluid = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getNearestLookingDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.getType() == Fluids.WATER));
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)level.getBlockEntity(pos));
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BambooBasketBE(pos, state);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity tileEntity = level.getBlockEntity(pos);
            if (tileEntity instanceof Container) {
                Containers.dropContents((Level)level, (BlockPos)pos, (Container)((Container)tileEntity));
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity tileEntity;
        if (!level.isClientSide && (tileEntity = level.getBlockEntity(pos)) instanceof BambooBasketBE) {
            player.openMenu((MenuProvider)((BambooBasketBE)tileEntity));
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : BambooBasketB.createTickerHelper(blockEntityType, ModBlockEntities.BAMBOO_BASKET_BE.get(), BambooBasketBE::pushItemsTick);
    }
}

