/*
 * Decompiled with CFR 0.152.
 */
package com.archaeological_research.exploration.blocks.bamboo;

import com.archaeological_research.exploration.addon.arr.ArrBasket;
import com.archaeological_research.exploration.addon.arr.ArrInvWrapper;
import com.archaeological_research.exploration.blocks.bamboo.BambooBasketB;
import com.archaeological_research.exploration.register.ModBlockEntities;
import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;

public class BambooBasketBE
extends RandomizableContainerBlockEntity
implements ArrBasket {
    private NonNullList<ItemStack> items = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
    private int transferCooldown = -1;

    public BambooBasketBE(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.BAMBOO_BASKET_BE.get(), pos, blockState);
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, ModBlockEntities.BAMBOO_BASKET_BE.get(), (be, context) -> new ArrInvWrapper((ArrBasket)be));
    }

    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(compound)) {
            ContainerHelper.loadAllItems((CompoundTag)compound, this.items, (HolderLookup.Provider)registries);
        }
        this.transferCooldown = compound.getInt("TransferCooldown");
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        if (!this.trySaveLootTable(compound)) {
            ContainerHelper.saveAllItems((CompoundTag)compound, this.items, (HolderLookup.Provider)registries);
        }
        compound.putInt("TransferCooldown", this.transferCooldown);
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public ItemStack removeItem(int index, int count) {
        this.unpackLootTable(null);
        return ContainerHelper.removeItem(this.getItems(), (int)index, (int)count);
    }

    public void setItem(int index, ItemStack stack) {
        this.unpackLootTable(null);
        this.getItems().set(index, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"block.archaeological_research_exploration.bamboo_basket");
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> itemsIn) {
        this.items = itemsIn;
    }

    protected AbstractContainerMenu createMenu(int id, Inventory player) {
        return ChestMenu.threeRows((int)id, (Inventory)player, (Container)this);
    }

    @Override
    public void setCooldown(int ticks) {
        this.transferCooldown = ticks;
    }

    @Override
    public boolean isOnCooldown() {
        return this.transferCooldown > 0;
    }

    @Override
    public boolean isOnCustomCooldown() {
        return this.transferCooldown > 8;
    }

    @Override
    public void tryTransfer(BooleanSupplier transfer) {
        if (this.level != null && !this.level.isClientSide && !this.isOnCooldown() && ((Boolean)this.getBlockState().getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
            boolean flag = false;
            if (!this.isFull()) {
                flag = transfer.getAsBoolean();
            }
            if (flag) {
                this.setCooldown(8);
                this.setChanged();
            }
        }
    }

    protected boolean isFull() {
        for (ItemStack itemstack : this.items) {
            if (!itemstack.isEmpty() && itemstack.getCount() == itemstack.getMaxStackSize()) continue;
            return false;
        }
        return true;
    }

    @Override
    public double getLevelX() {
        return (double)this.worldPosition.getX() + 0.5;
    }

    @Override
    public double getLevelY() {
        return (double)this.worldPosition.getY() + 0.5;
    }

    @Override
    public double getLevelZ() {
        return (double)this.worldPosition.getZ() + 0.5;
    }

    public static void pushItemsTick(Level level, BlockPos pos, BlockState state, BambooBasketBE blockEntity) {
        --blockEntity.transferCooldown;
        if (!blockEntity.isOnCooldown()) {
            blockEntity.setCooldown(0);
            int facing = ((Direction)state.getValue((Property)BambooBasketB.FACING)).get3DDataValue();
            blockEntity.tryTransfer(() -> blockEntity.collectItems(level, facing));
        }
    }
}

