/*
 * Decompiled with CFR 0.152.
 */
package com.archaeological_research.exploration.blocks.bamboo;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BambooFrameB
extends Block
implements SimpleWaterloggedBlock {
    public static final MapCodec<BambooFrameB> CODEC = BambooFrameB.simpleCodec(BambooFrameB::new);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), (VoxelShape[])new VoxelShape[0]);

    public BambooFrameB(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED});
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos;
        BlockPos belowPos;
        Level level = context.getLevel();
        BlockState belowState = level.getBlockState(belowPos = (pos = context.getClickedPos()).below());
        if (this.isValidSupportBlock(belowState) && this.isCorrectHeightY(pos)) {
            return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos).getType() == Fluids.WATER));
        }
        return null;
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    private boolean isValidSupportBlock(BlockState state) {
        return state.isSolid() || state.getBlock() instanceof BambooFrameB;
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (!level.isClientSide()) {
            level.scheduleTick(currentPos, (Block)this, 1);
        }
        return state;
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof Player && entity.getLookAngle().y > 0.9 && entity.isShiftKeyDown()) {
            boolean isSafe;
            BlockPos targetPos = this.findFirstNonScaffoldingAbove(level, pos);
            boolean bl = isSafe = level.getBlockState(targetPos).is(Blocks.AIR) && level.getBlockState(targetPos.above()).is(Blocks.AIR);
            if (isSafe) {
                entity.teleportTo(targetPos.getCenter().x, (double)(targetPos.getY() + 1), targetPos.getCenter().z);
                level.playSound(null, pos, SoundEvents.ENDERMAN_TELEPORT, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockPos belowPos = pos.below();
        if (!this.isValidSupportBlock(level.getBlockState(belowPos))) {
            level.destroyBlock(pos, true);
        }
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (context.isAbove(Shapes.block(), pos, true) && !context.isDescending()) {
            return SHAPE;
        }
        return Shapes.empty();
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockPos placePos;
        ItemStack heldStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (heldStack.getItem() == this.asItem() && (placePos = this.findFirstNonScaffoldingAbove(level, pos)) != null && this.isCorrectHeightY(placePos) && this.isValidSupportBlock(level.getBlockState(placePos.below()))) {
            level.setBlock(placePos, this.defaultBlockState(), 3);
            level.playSound(null, placePos, SoundEvents.SCAFFOLDING_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.isCreative()) {
                heldStack.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    private BlockPos findFirstNonScaffoldingAbove(Level level, BlockPos startPos) {
        BlockPos currentPos = startPos.above();
        while (level.getBlockState(currentPos).getBlock() instanceof BambooFrameB) {
            if ((currentPos = currentPos.above()).getY() < level.getMaxBuildHeight() - 1) continue;
            return null;
        }
        if (level.getBlockState(currentPos.below()).getBlock() instanceof BambooFrameB) {
            return currentPos;
        }
        return null;
    }

    private boolean isCorrectHeightY(BlockPos pos) {
        return pos.getY() < 200;
    }
}

