/*
 * Decompiled with CFR 0.152.
 */
package com.archaeological_research.exploration.blocks.bamboo;

import com.archaeological_research.exploration.blocks.bamboo.BambooGrowingShelfBE;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class BambooGrowingShelfBER
implements BlockEntityRenderer<BambooGrowingShelfBE> {
    private static final float SIZE = 0.265f;
    private final ItemRenderer itemRenderer;

    public BambooGrowingShelfBER(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.getItemRenderer();
    }

    public void render(BambooGrowingShelfBE blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        NonNullList<ItemStack> nonnulllist = blockEntity.getItems();
        int i = (int)blockEntity.getBlockPos().asLong();
        for (int j = 0; j < nonnulllist.size(); ++j) {
            ItemStack itemstack = (ItemStack)nonnulllist.get(j);
            if (itemstack == ItemStack.EMPTY) continue;
            poseStack.pushPose();
            switch (j) {
                case 0: {
                    poseStack.translate(0.5f, 0.325f, 0.5f);
                    poseStack.scale(0.9f, 0.9f, 0.9f);
                    break;
                }
                case 1: {
                    poseStack.translate(0.5f, 0.7f, 0.5f);
                    poseStack.scale(0.265f, 0.265f, 0.265f);
                    poseStack.mulPose(Axis.YP.rotationDegrees(blockEntity.getRotation()));
                }
            }
            this.itemRenderer.renderStatic(itemstack, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, blockEntity.getLevel(), i + j);
            poseStack.popPose();
        }
    }
}

