/*
 * Decompiled with CFR 0.152.
 */
package com.archaeological_research.exploration.blocks.custom;

import com.archaeological_research.exploration.register.ModBlocks;
import com.archaeological_research.exploration.register.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BambooB
extends Block {
    public static final IntegerProperty PROGRESS = IntegerProperty.create((String)"progress", (int)0, (int)4);
    private static final VoxelShape SHAPE_P0 = Shapes.or((VoxelShape)Block.box((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)13.0, (double)9.5), (VoxelShape)Block.box((double)6.5, (double)13.0, (double)6.5, (double)9.5, (double)16.0, (double)9.5));
    private static final VoxelShape SHAPE_P1 = Shapes.or((VoxelShape)SHAPE_P0, (VoxelShape[])new VoxelShape[0]);
    private static final VoxelShape SHAPE_P2 = Shapes.or((VoxelShape)Block.box((double)12.0, (double)0.0, (double)6.5, (double)15.0, (double)16.0, (double)9.5), (VoxelShape)Block.box((double)1.0, (double)0.0, (double)6.5, (double)4.0, (double)16.0, (double)9.5));
    private static final VoxelShape SHAPE_P3 = Shapes.or((VoxelShape)Block.box((double)12.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)5.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)0.0, (double)2.0, (double)4.0, (double)16.0, (double)5.0), Block.box((double)2.0, (double)0.0, (double)12.0, (double)5.0, (double)16.0, (double)15.0)});
    private static final VoxelShape SHAPE_P4 = Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), (VoxelShape[])new VoxelShape[0]);

    public BambooB(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)PROGRESS, (Comparable)Integer.valueOf(0)));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Integer)state.getValue((Property)PROGRESS)) {
            case 0 -> SHAPE_P1;
            case 1 -> SHAPE_P2;
            default -> SHAPE_P4;
        };
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PROGRESS});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack itemInHand = player.getItemInHand(hand);
        if (itemInHand.isEmpty()) {
            return ItemInteractionResult.CONSUME;
        }
        int progress = (Integer)state.getValue((Property)PROGRESS);
        boolean isBambooTube = itemInHand.is(ModItems.BAMBOO_TUBE);
        boolean isBamboo = itemInHand.is(Items.BAMBOO);
        if (isBambooTube && progress < 3) {
            this.applyChangeAndConsume(level, pos, state, itemInHand, (Property<Integer>)PROGRESS, progress + 1);
            return ItemInteractionResult.SUCCESS;
        }
        if (isBamboo) {
            switch (progress) {
                case 1: {
                    level.setBlock(pos, ((Block)ModBlocks.BAMBOO_RACK.get()).defaultBlockState(), 3);
                    this.consumeItemAndPlaySound(itemInHand, level, pos);
                    return ItemInteractionResult.SUCCESS;
                }
                case 3: {
                    this.applyChangeAndConsume(level, pos, state, itemInHand, (Property<Integer>)PROGRESS, progress + 1);
                    return ItemInteractionResult.SUCCESS;
                }
                case 4: {
                    level.setBlock(pos, ((Block)ModBlocks.BAMBOO_FRAME.get()).defaultBlockState(), 3);
                    this.consumeItemAndPlaySound(itemInHand, level, pos);
                    return ItemInteractionResult.SUCCESS;
                }
            }
        }
        return ItemInteractionResult.CONSUME;
    }

    private void applyChangeAndConsume(Level level, BlockPos pos, BlockState state, ItemStack itemInHand, Property<Integer> property, int newValue) {
        level.setBlock(pos, (BlockState)state.setValue(property, (Comparable)Integer.valueOf(newValue)), 3);
        this.consumeItemAndPlaySound(itemInHand, level, pos);
    }

    private void consumeItemAndPlaySound(ItemStack itemInHand, Level level, BlockPos pos) {
        itemInHand.shrink(1);
        try {
            this.playSound(level, pos);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void playSound(Level level, BlockPos pos) {
        level.playSound(null, pos, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
    }
}

