/*
 * Decompiled with CFR 0.152.
 */
package com.archaeological_research.exploration.blocks.custom;

import com.archaeological_research.exploration.register.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FirewoodB
extends Block {
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    private int time = 0;
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)1.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)11.0, (double)0.0, (double)0.0, (double)15.0, (double)4.0, (double)16.0), Block.box((double)1.0, (double)0.0, (double)0.0, (double)5.0, (double)4.0, (double)16.0), Block.box((double)0.0, (double)3.0, (double)11.0, (double)16.0, (double)7.0, (double)15.0), Block.box((double)0.0, (double)3.0, (double)1.0, (double)16.0, (double)7.0, (double)5.0)});
    private static final VoxelShape SHAPE_LIT = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);

    public FirewoodB(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)LIT) != false ? SHAPE_LIT : SHAPE;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT});
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            if (!this.cancelFire((Level)level, pos)) {
                return Blocks.AIR.defaultBlockState();
            }
            if (level.getBlockState(pos.above()).is(Blocks.AIR)) {
                return ((Block)ModBlocks.CHARCOAL_PILE.get()).defaultBlockState();
            }
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            level.scheduleTick(pos.above(), Blocks.AIR, 10);
        }
        super.randomTick(state, level, pos, random);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack itemInHand = player.getItemInHand(hand);
        if (itemInHand.isEmpty()) {
            return ItemInteractionResult.CONSUME;
        }
        if (itemInHand.getItem() instanceof FlintAndSteelItem && this.cancelFire(level, pos)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)), 3);
            level.setBlock(pos.above(), Blocks.FIRE.defaultBlockState(), 3);
            itemInHand.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.CONSUME;
    }

    private boolean cancelFire(Level level, BlockPos pos) {
        BlockState[] blockStates;
        for (BlockState blockState : blockStates = new BlockState[]{level.getBlockState(pos.north()), level.getBlockState(pos.south()), level.getBlockState(pos.east()), level.getBlockState(pos.west()), level.getBlockState(pos.below())}) {
            if (blockState.isCollisionShapeFullBlock((BlockGetter)level, pos)) continue;
            return false;
        }
        return true;
    }
}

