/*
 * Decompiled with CFR 0.152.
 */
package com.archaeological_research.exploration.blocks.custom;

import com.archaeological_research.exploration.register.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class OreEmbryoB
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final IntegerProperty PROGRESS = IntegerProperty.create((String)"progress", (int)1, (int)4);
    public static final IntegerProperty MAX_TIMES = IntegerProperty.create((String)"max_times", (int)0, (int)5);
    public static final VoxelShape AGE_SHAPE_1 = Shapes.or((VoxelShape)Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), (VoxelShape[])new VoxelShape[0]);
    public static final VoxelShape AGE_SHAPE_2 = Shapes.or((VoxelShape)Block.box((double)5.0, (double)0.0, (double)4.0, (double)11.0, (double)4.0, (double)12.0), (VoxelShape[])new VoxelShape[0]);
    public static final VoxelShape AGE_SHAPE_2_WITH_EAST = Shapes.or((VoxelShape)Block.box((double)4.0, (double)0.0, (double)5.0, (double)12.0, (double)4.0, (double)11.0), (VoxelShape[])new VoxelShape[0]);
    public static final VoxelShape AGE_SHAPE_3 = Shapes.or((VoxelShape)Block.box((double)6.0, (double)0.0, (double)4.0, (double)10.0, (double)3.0, (double)12.0), (VoxelShape[])new VoxelShape[0]);
    public static final VoxelShape AGE_SHAPE_3_WITH_EAST = Shapes.or((VoxelShape)Block.box((double)4.0, (double)0.0, (double)6.0, (double)12.0, (double)3.0, (double)10.0), (VoxelShape[])new VoxelShape[0]);
    public static final VoxelShape AGE_SHAPE_4 = Shapes.or((VoxelShape)Block.box((double)6.0, (double)0.0, (double)5.0, (double)10.0, (double)2.0, (double)11.0), (VoxelShape[])new VoxelShape[0]);
    public static final VoxelShape AGE_SHAPE_4_WITH_EAST = Shapes.or((VoxelShape)Block.box((double)5.0, (double)0.0, (double)6.0, (double)11.0, (double)2.0, (double)10.0), (VoxelShape[])new VoxelShape[0]);

    public OreEmbryoB(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)PROGRESS, (Comparable)Integer.valueOf(1))).setValue((Property)MAX_TIMES, (Comparable)Integer.valueOf(0)));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        int progress = (Integer)state.getValue((Property)PROGRESS);
        if (facing.getAxis() == Direction.Axis.Z) {
            return switch (progress) {
                case 2 -> AGE_SHAPE_2;
                case 3 -> AGE_SHAPE_3;
                case 4 -> AGE_SHAPE_4;
                default -> AGE_SHAPE_1;
            };
        }
        if (facing.getAxis() == Direction.Axis.X) {
            return switch (progress) {
                case 2 -> AGE_SHAPE_2_WITH_EAST;
                case 3 -> AGE_SHAPE_3_WITH_EAST;
                case 4 -> AGE_SHAPE_4_WITH_EAST;
                default -> AGE_SHAPE_1;
            };
        }
        return AGE_SHAPE_1;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, PROGRESS, MAX_TIMES});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity) {
            entity.hurt(level.damageSources().campfire(), 1.0f);
        }
        super.entityInside(state, level, pos, entity);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (random.nextInt(10) == 0) {
            level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.CAMPFIRE_CRACKLE, SoundSource.BLOCKS, 0.5f + random.nextFloat(), random.nextFloat() * 0.7f + 0.6f, false);
        }
        if (random.nextInt(5) == 0) {
            for (int i = 0; i < random.nextInt(1) + 1; ++i) {
                level.addParticle((ParticleOptions)ParticleTypes.LAVA, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (double)(random.nextFloat() / 2.0f), 5.0E-5, (double)(random.nextFloat() / 2.0f));
            }
        }
    }

    public int getProgress(BlockState state) {
        return (Integer)state.getValue((Property)PROGRESS);
    }

    public boolean addProgress(Level level, BlockPos pos, BlockState state) {
        int currentMaxTimes = (Integer)state.getValue((Property)MAX_TIMES);
        int currentProgress = (Integer)state.getValue((Property)PROGRESS);
        if (currentProgress != 4 && (level.random.nextInt(20) == 0 || currentMaxTimes == 5)) {
            level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)PROGRESS, (Comparable)Integer.valueOf(currentProgress + 1))).setValue((Property)MAX_TIMES, (Comparable)Integer.valueOf(0)), 3);
            return true;
        }
        level.setBlock(pos, (BlockState)state.setValue((Property)MAX_TIMES, (Comparable)Integer.valueOf(currentMaxTimes + 1)), 3);
        return false;
    }

    public static ItemStack dropItem(BlockState state) {
        if (state.getBlock() == ModBlocks.COPPER_EMBRYO.get()) {
            return Items.COPPER_INGOT.getDefaultInstance();
        }
        if (state.getBlock() == ModBlocks.IRON_EMBRYO.get()) {
            return Items.IRON_INGOT.getDefaultInstance();
        }
        if (state.getBlock() == ModBlocks.GOLD_EMBRYO.get()) {
            return Items.GOLD_INGOT.getDefaultInstance();
        }
        return Items.AIR.getDefaultInstance();
    }
}

