/*
 * Decompiled with CFR 0.152.
 */
package com.archaeological_research.exploration.blocks.custom;

import com.archaeological_research.exploration.register.ModBlocks;
import com.archaeological_research.exploration.register.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TinderB
extends Block {
    public static final IntegerProperty PROGRESS = IntegerProperty.create((String)"progress", (int)0, (int)11);
    private static final VoxelShape SHAPE_STONE = Shapes.or((VoxelShape)Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0), (VoxelShape[])new VoxelShape[0]);
    private static final VoxelShape SHAPE_STONE1 = Shapes.or((VoxelShape)SHAPE_STONE, (VoxelShape)Block.box((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)4.0, (double)3.0));
    private static final VoxelShape SHAPE_STONE2 = Shapes.or((VoxelShape)SHAPE_STONE1, (VoxelShape)Block.box((double)0.0, (double)0.0, (double)5.0, (double)3.0, (double)4.0, (double)11.0));
    private static final VoxelShape SHAPE_STONE3 = Shapes.or((VoxelShape)SHAPE_STONE2, (VoxelShape)Block.box((double)5.0, (double)0.0, (double)13.0, (double)11.0, (double)4.0, (double)16.0));
    private static final VoxelShape SHAPE_STONE4 = Shapes.or((VoxelShape)SHAPE_STONE3, (VoxelShape)Block.box((double)13.0, (double)0.0, (double)5.0, (double)16.0, (double)4.0, (double)11.0));
    private static final VoxelShape SHAPE_STONE5 = Shapes.or((VoxelShape)SHAPE_STONE4, (VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0));
    private static final VoxelShape SHAPE_LOG = Shapes.or((VoxelShape)Block.box((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)1.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    private static final VoxelShape SHAPE_LOG1 = Shapes.or((VoxelShape)SHAPE_LOG, (VoxelShape)Block.box((double)11.0, (double)0.0, (double)0.0, (double)15.0, (double)4.0, (double)16.0));
    private static final VoxelShape SHAPE_LOG2 = Shapes.or((VoxelShape)SHAPE_LOG1, (VoxelShape)Block.box((double)1.0, (double)0.0, (double)0.0, (double)5.0, (double)4.0, (double)16.0));
    private static final VoxelShape SHAPE_LOG3 = Shapes.or((VoxelShape)SHAPE_LOG2, (VoxelShape)Block.box((double)0.0, (double)3.0, (double)11.0, (double)16.0, (double)7.0, (double)15.0));

    public TinderB(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)PROGRESS, (Comparable)Integer.valueOf(0)));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Integer)state.getValue((Property)PROGRESS)) {
            case 0 -> SHAPE_STONE;
            case 1 -> SHAPE_STONE1;
            case 2 -> SHAPE_STONE2;
            case 3 -> SHAPE_STONE3;
            case 4 -> SHAPE_STONE4;
            case 5, 6, 7 -> SHAPE_STONE5;
            case 8 -> SHAPE_LOG;
            case 9 -> SHAPE_LOG1;
            case 10 -> SHAPE_LOG2;
            case 11 -> SHAPE_LOG3;
            default -> SHAPE_STONE;
        };
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PROGRESS});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return ItemInteractionResult.CONSUME;
        }
        ItemStack itemInHand = player.getItemInHand(hand);
        int progress = (Integer)state.getValue((Property)PROGRESS);
        if (itemInHand.isEmpty()) {
            return ItemInteractionResult.CONSUME;
        }
        boolean success = false;
        if (itemInHand.is(ModItems.DRIED_FIBER) && progress == 0) {
            level.setBlock(pos, (BlockState)state.setValue((Property)PROGRESS, (Comparable)Integer.valueOf(8)), 3);
            success = true;
        } else if (itemInHand.is(ModItems.STONE_CORE)) {
            switch (progress) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    level.setBlock(pos, (BlockState)state.setValue((Property)PROGRESS, (Comparable)Integer.valueOf(progress + 1)), 3);
                    success = true;
                    break;
                }
                case 7: {
                    level.setBlock(pos, ((Block)ModBlocks.STONE_FIRE_PIT.get()).defaultBlockState(), 3);
                    success = true;
                }
            }
        } else if (itemInHand.is(ItemTags.LOGS)) {
            switch (progress) {
                case 8: 
                case 9: 
                case 10: {
                    level.setBlock(pos, (BlockState)state.setValue((Property)PROGRESS, (Comparable)Integer.valueOf(progress + 1)), 3);
                    success = true;
                    break;
                }
                case 11: {
                    level.setBlock(pos, ((Block)ModBlocks.FIREWOOD_PILE.get()).defaultBlockState(), 3);
                    success = true;
                }
            }
        }
        if (success) {
            itemInHand.shrink(1);
            try {
                this.playSound(level, pos);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.CONSUME;
    }

    private void playSound(Level level, BlockPos pos) {
        level.playSound(null, pos, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
    }
}

