/*
 * Decompiled with CFR 0.152.
 */
package com.archaeological_research.exploration.blocks.recipe;

import com.archaeological_research.exploration.addon.arr.SimpleRecipeInput;
import com.archaeological_research.exploration.register.ModRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record CuttingRecipe(Ingredient inputItem, ItemStack output, int progress) implements Recipe<SimpleRecipeInput>
{
    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredient = NonNullList.create();
        ingredient.add((Object)this.inputItem);
        return ingredient;
    }

    public boolean matches(SimpleRecipeInput input, Level level) {
        if (level.isClientSide) {
            return false;
        }
        return this.inputItem.test(input.getItem(0));
    }

    public ItemStack assemble(SimpleRecipeInput input, HolderLookup.Provider registries) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.output;
    }

    public int getProgress() {
        return this.progress;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.CUTTING.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.CUTTING_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<CuttingRecipe> {
        public static final MapCodec<CuttingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("ingredients").forGetter(CuttingRecipe::inputItem), (App)ItemStack.CODEC.fieldOf("result").forGetter(CuttingRecipe::output), (App)Codec.INT.fieldOf("progress").forGetter(CuttingRecipe::progress)).apply((Applicative)instance, CuttingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CuttingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, CuttingRecipe::inputItem, (StreamCodec)ItemStack.STREAM_CODEC, CuttingRecipe::output, (StreamCodec)ByteBufCodecs.INT, CuttingRecipe::progress, CuttingRecipe::new);

        public MapCodec<CuttingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CuttingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

