/*
 * Decompiled with CFR 0.152.
 */
package com.archaeological_research.exploration.blocks.recipe;

import com.archaeological_research.exploration.addon.arr.SimpleRecipeInput;
import com.archaeological_research.exploration.register.ModRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record DryingRecipe(Ingredient inputItem, ItemStack output, int progress) implements Recipe<SimpleRecipeInput>
{
    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredient = NonNullList.create();
        ingredient.add((Object)this.inputItem);
        return ingredient;
    }

    public boolean matches(SimpleRecipeInput input, Level level) {
        if (level.isClientSide) {
            return false;
        }
        return this.inputItem.test(input.getItem(0));
    }

    public ItemStack assemble(SimpleRecipeInput input, HolderLookup.Provider registries) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.output;
    }

    public int getProgress() {
        return this.progress;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.DRYING.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.DRYING_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<DryingRecipe> {
        public static final MapCodec<DryingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("ingredients").forGetter(DryingRecipe::inputItem), (App)ItemStack.CODEC.fieldOf("result").forGetter(DryingRecipe::output), (App)Codec.INT.fieldOf("progress").forGetter(DryingRecipe::progress)).apply((Applicative)instance, DryingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, DryingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, DryingRecipe::inputItem, (StreamCodec)ItemStack.STREAM_CODEC, DryingRecipe::output, (StreamCodec)ByteBufCodecs.INT, DryingRecipe::progress, DryingRecipe::new);

        public MapCodec<DryingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, DryingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

