/*
 * Decompiled with CFR 0.152.
 */
package com.archaeological_research.exploration.blocks.recipe;

import com.archaeological_research.exploration.addon.arr.ComplicatedRecipeInput;
import com.archaeological_research.exploration.register.ModRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record GrowingRecipe(Ingredient inputItem, ItemStack output, int progress) implements Recipe<ComplicatedRecipeInput>
{
    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredient = NonNullList.create();
        ingredient.add((Object)this.inputItem);
        return ingredient;
    }

    public boolean matches(ComplicatedRecipeInput input, Level level) {
        if (level.isClientSide) {
            return false;
        }
        return this.inputItem.test(input.getItem(0)) && this.inputItem.test(input.getItem(1));
    }

    public ItemStack assemble(ComplicatedRecipeInput input, HolderLookup.Provider registries) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.output;
    }

    public int getProgress() {
        return this.progress;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.GROWING.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.GROWING_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<GrowingRecipe> {
        public static final MapCodec<GrowingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("ingredients").forGetter(GrowingRecipe::inputItem), (App)ItemStack.CODEC.fieldOf("result").forGetter(GrowingRecipe::output), (App)Codec.INT.fieldOf("progress").forGetter(GrowingRecipe::progress)).apply((Applicative)instance, GrowingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, GrowingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, GrowingRecipe::inputItem, (StreamCodec)ItemStack.STREAM_CODEC, GrowingRecipe::output, (StreamCodec)ByteBufCodecs.INT, GrowingRecipe::progress, GrowingRecipe::new);

        public MapCodec<GrowingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, GrowingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

