/*
 * Decompiled with CFR 0.152.
 */
package com.archaeological_research.exploration.blocks.sculk;

import com.archaeological_research.exploration.addon.arr.SimpleRecipeInput;
import com.archaeological_research.exploration.blocks.recipe.NegentropyRecipe;
import com.archaeological_research.exploration.blocks.sculk.SculkEntropyNexusB;
import com.archaeological_research.exploration.register.ModBlockEntities;
import com.archaeological_research.exploration.register.ModRecipes;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class SculkEntropyNexusBE
extends BlockEntity
implements Clearable {
    public final NonNullList<ItemStack> items = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    public final int[] cookingProgress = new int[1];
    public final int[] cookingTime = new int[1];

    public SculkEntropyNexusBE(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.STONE_SACRIFICIAL_TABLE_BE.get(), pos, blockState);
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.items.clear();
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        if (tag.contains("CookingTimes", 11)) {
            int[] aint = tag.getIntArray("CookingTimes");
            System.arraycopy(aint, 0, this.cookingProgress, 0, Math.min(this.cookingTime.length, aint.length));
        }
        if (tag.contains("CookingTotalTimes", 11)) {
            int[] aint1 = tag.getIntArray("CookingTotalTimes");
            System.arraycopy(aint1, 0, this.cookingTime, 0, Math.min(this.cookingTime.length, aint1.length));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (boolean)true, (HolderLookup.Provider)registries);
        tag.putIntArray("CookingTimes", this.cookingProgress);
        tag.putIntArray("CookingTotalTimes", this.cookingTime);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag compoundtag = new CompoundTag();
        ContainerHelper.saveAllItems((CompoundTag)compoundtag, this.items, (boolean)true, (HolderLookup.Provider)registries);
        return compoundtag;
    }

    public Optional<RecipeHolder<NegentropyRecipe>> getCookableRecipe(ItemStack stack) {
        return this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.NEGENTROPY_TYPE.get(), (RecipeInput)new SimpleRecipeInput(stack), this.level);
    }

    public boolean placeItem(@Nullable LivingEntity entity, ItemStack item, int cookTime) {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.items.get(i);
            if (!itemstack.isEmpty()) continue;
            this.cookingTime[i] = cookTime;
            this.cookingProgress[i] = 0;
            this.items.set(i, (Object)item.consumeAndReturn(1, entity));
            this.level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, this.getBlockPos(), GameEvent.Context.of((Entity)entity, (BlockState)this.getBlockState()));
            this.markUpdated();
            return true;
        }
        return false;
    }

    public static void cookTick(Level level, BlockPos pos, BlockState state, SculkEntropyNexusBE blockEntity) {
        boolean flag = false;
        for (int i = 0; i < blockEntity.items.size(); ++i) {
            ItemStack itemStack;
            Optional<RecipeHolder<NegentropyRecipe>> recipe;
            ItemStack slot = (ItemStack)blockEntity.items.get(i);
            if (slot.isEmpty()) continue;
            flag = true;
            int n = i;
            blockEntity.cookingProgress[n] = blockEntity.cookingProgress[n] + 1;
            blockEntity.particleTick(level, pos);
            if (blockEntity.cookingProgress[i] < blockEntity.cookingTime[i] || !(recipe = blockEntity.getCookableRecipe(slot)).isPresent() || !(itemStack = ((NegentropyRecipe)recipe.get().value()).assemble(new SimpleRecipeInput(slot), (HolderLookup.Provider)level.registryAccess())).isItemEnabled(level.enabledFeatures())) continue;
            Containers.dropItemStack((Level)level, (double)pos.getCenter().x, (double)(pos.getCenter().y + 0.5), (double)pos.getCenter().z, (ItemStack)itemStack);
            blockEntity.items.set(i, (Object)ItemStack.EMPTY);
            blockEntity.level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.5f, 0.4f);
            level.sendBlockUpdated(pos, state, state, 3);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)state));
        }
        if (flag) {
            SculkEntropyNexusBE.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public void particleTick(Level level, BlockPos pos) {
        RandomSource randomsource = level.random;
        if (randomsource.nextFloat() < 0.01f) {
            for (int i = 0; i < randomsource.nextInt(2) + 1; ++i) {
                SculkEntropyNexusB.makeParticles(level, pos);
            }
        }
    }

    private void markUpdated() {
        this.setChanged();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    public void clearContent() {
        this.items.clear();
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        ((ItemContainerContents)componentInput.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).copyInto(this.getItems());
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.getItems()));
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        tag.remove("Items");
    }
}

