/*
 * Decompiled with CFR 0.152.
 */
package com.archaeological_research.exploration.blocks.stone;

import com.archaeological_research.exploration.blocks.recipe.ForgingRecipe;
import com.archaeological_research.exploration.blocks.stone.StoneAnvilBE;
import com.archaeological_research.exploration.item.tool.ModHammerItme;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class StoneAnvilB
extends BaseEntityBlock {
    public static final MapCodec<StoneAnvilB> CODEC = StoneAnvilB.simpleCodec(StoneAnvilB::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final VoxelShape BASE_SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
    public static final VoxelShape X_AXIS_SHAPE = Shapes.or((VoxelShape)BASE_SHAPE, (VoxelShape[])new VoxelShape[]{Block.box((double)3.0, (double)4.0, (double)4.0, (double)13.0, (double)5.0, (double)12.0), Block.box((double)4.0, (double)5.0, (double)6.0, (double)12.0, (double)10.0, (double)10.0), Block.box((double)0.0, (double)10.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0)});
    public static final VoxelShape Z_AXIS_SHAPE = Shapes.or((VoxelShape)BASE_SHAPE, (VoxelShape[])new VoxelShape[]{Block.box((double)4.0, (double)4.0, (double)3.0, (double)12.0, (double)5.0, (double)13.0), Block.box((double)6.0, (double)5.0, (double)4.0, (double)10.0, (double)10.0, (double)12.0), Block.box((double)3.0, (double)10.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0)});

    public StoneAnvilB(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return ((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.X ? X_AXIS_SHAPE : Z_AXIS_SHAPE;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new StoneAnvilBE(pos, state);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockentity = level.getBlockEntity(pos);
            if (blockentity instanceof StoneAnvilBE) {
                Containers.dropContents((Level)level, (BlockPos)pos, ((StoneAnvilBE)blockentity).getItems());
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack hand1;
        ItemStack itemstack;
        StoneAnvilBE blockEntity;
        Optional<RecipeHolder<ForgingRecipe>> recipe;
        BlockEntity blockEntity2 = level.getBlockEntity(pos);
        if (blockEntity2 instanceof StoneAnvilBE && (recipe = (blockEntity = (StoneAnvilBE)blockEntity2).getCookableRecipe(itemstack = (hand1 = player.getItemInHand(InteractionHand.MAIN_HAND)).getItem() instanceof ModHammerItme ? player.getItemInHand(InteractionHand.OFF_HAND) : hand1)).isPresent() && blockEntity.placeItem((LivingEntity)player, itemstack, ((ForgingRecipe)recipe.get().value()).getProgress())) {
            level.playSound(null, pos, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 0.8f);
            player.awardStat(Stats.INTERACT_WITH_CAMPFIRE);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.CONSUME;
    }

    public static void makeParticles(Level level, BlockPos pos, ItemStack item) {
        Vec3 vec3 = new Vec3((double)level.getRandom().nextFloat() - 0.5, Math.random() * (double)0.1f + (double)0.1f, (double)level.getRandom().nextFloat() - 0.5);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, item), (double)pos.getX() + 0.5, (double)pos.getY() + 1.2, (double)pos.getZ() + 0.5, 1, vec3.x, vec3.y, vec3.z, 0.05);
        } else {
            level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, item), (double)pos.getX() + 0.5, (double)pos.getY() + 1.2, (double)pos.getZ() + 0.5, vec3.x, vec3.y, vec3.z);
        }
    }
}

