/*
 * Decompiled with CFR 0.152.
 */
package com.archaeological_research.exploration.blocks.stone;

import com.archaeological_research.exploration.blocks.stone.StoneFirePitB;
import com.archaeological_research.exploration.register.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class StoneFirePitBE
extends RandomizableContainerBlockEntity {
    private NonNullList<ItemStack> items = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void onOpen(Level level, BlockPos pos, BlockState state) {
            level.playSound(null, (double)StoneFirePitBE.this.worldPosition.getX(), (double)StoneFirePitBE.this.worldPosition.getY(), (double)StoneFirePitBE.this.worldPosition.getZ(), SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
            level.setBlock(pos, (BlockState)state.setValue((Property)BarrelBlock.OPEN, (Comparable)Boolean.TRUE), 3);
        }

        protected void onClose(Level level, BlockPos pos, BlockState state) {
            level.playSound(null, (double)StoneFirePitBE.this.worldPosition.getX(), (double)StoneFirePitBE.this.worldPosition.getY(), (double)StoneFirePitBE.this.worldPosition.getZ(), SoundEvents.FIRE_AMBIENT, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
            level.setBlock(pos, (BlockState)state.setValue((Property)BarrelBlock.OPEN, (Comparable)Boolean.FALSE), 3);
        }

        protected void openerCountChanged(Level level, BlockPos pos, BlockState state, int eventId, int eventParam) {
        }

        protected boolean isOwnContainer(Player player) {
            if (!(player.containerMenu instanceof ChestMenu)) {
                return false;
            }
            Container container = ((ChestMenu)player.containerMenu).getContainer();
            return container == StoneFirePitBE.this || container instanceof CompoundContainer && ((CompoundContainer)container).contains((Container)StoneFirePitBE.this);
        }
    };

    public StoneFirePitBE(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.STONE_FIRE_PIT_BE.get(), pos, blockState);
    }

    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(compound)) {
            ContainerHelper.loadAllItems((CompoundTag)compound, this.items, (HolderLookup.Provider)registries);
        }
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        if (!this.trySaveLootTable(compound)) {
            ContainerHelper.saveAllItems((CompoundTag)compound, this.items, (HolderLookup.Provider)registries);
        }
    }

    public int getContainerSize() {
        return this.items.size();
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"block.archaeological_research_exploration.stone_fire_pit");
    }

    protected AbstractContainerMenu createMenu(int id, Inventory player) {
        return ChestMenu.threeRows((int)id, (Inventory)player, (Container)this);
    }

    public static void clearTick(Level level, BlockPos pos, BlockState state, StoneFirePitBE blockEntity) {
        boolean flag = false;
        for (int i = 0; i < blockEntity.items.size(); ++i) {
            ItemStack slot = (ItemStack)blockEntity.items.get(i);
            if (slot.isEmpty()) continue;
            flag = true;
            blockEntity.clearContent();
            blockEntity.markUpdated();
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)state));
        }
        if (flag) {
            StoneFirePitBE.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public static void particleTick(Level level, BlockPos pos, BlockState state, StoneFirePitBE blockEntity) {
        RandomSource randomsource = level.random;
        if (randomsource.nextFloat() < 0.15f) {
            for (int i = 0; i < randomsource.nextInt(2) + 2; ++i) {
                StoneFirePitB.makeParticles(level, pos, false, false);
            }
        }
        for (int j = 0; j < blockEntity.items.size(); ++j) {
            if (((ItemStack)blockEntity.items.get(j)).isEmpty() || !(randomsource.nextFloat() < 0.2f)) continue;
            Direction direction = Direction.from2DDataValue((int)Math.floorMod(j, 4));
            double d0 = (double)pos.getX() + 0.5 - (double)((float)direction.getStepX() * 0.3125f) + (double)((float)direction.getClockWise().getStepX() * 0.3125f);
            double d1 = (double)pos.getY() + 0.5;
            double d2 = (double)pos.getZ() + 0.5 - (double)((float)direction.getStepZ() * 0.3125f) + (double)((float)direction.getClockWise().getStepZ() * 0.3125f);
            for (int k = 0; k < 4; ++k) {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0.0, 5.0E-4, 0.0);
            }
        }
    }

    private void markUpdated() {
        this.setChanged();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    public void clearContent() {
        this.items.clear();
    }

    public void startOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.openersCounter.incrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.openersCounter.decrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }
}

