/*
 * Decompiled with CFR 0.152.
 */
package com.archaeological_research.exploration.blocks.stone;

import com.archaeological_research.exploration.register.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.DispenserMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class StoneVatBE
extends RandomizableContainerBlockEntity {
    private NonNullList<ItemStack> items = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void onOpen(Level level, BlockPos pos, BlockState state) {
            level.playSound(null, (double)StoneVatBE.this.worldPosition.getX(), (double)StoneVatBE.this.worldPosition.getY(), (double)StoneVatBE.this.worldPosition.getZ(), SoundEvents.BARREL_OPEN, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.05f);
            level.setBlock(pos, (BlockState)state.setValue((Property)BarrelBlock.OPEN, (Comparable)Boolean.TRUE), 3);
        }

        protected void onClose(Level level, BlockPos pos, BlockState state) {
            level.playSound(null, (double)StoneVatBE.this.worldPosition.getX(), (double)StoneVatBE.this.worldPosition.getY(), (double)StoneVatBE.this.worldPosition.getZ(), SoundEvents.BARREL_CLOSE, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f);
            level.setBlock(pos, (BlockState)state.setValue((Property)BarrelBlock.OPEN, (Comparable)Boolean.FALSE), 3);
        }

        protected void openerCountChanged(Level level, BlockPos pos, BlockState state, int eventId, int eventParam) {
            StoneVatBE.this.signalOpenCount(level, pos, state, eventId, eventParam);
        }

        protected boolean isOwnContainer(Player player) {
            if (!(player.containerMenu instanceof ChestMenu)) {
                return false;
            }
            Container container = ((ChestMenu)player.containerMenu).getContainer();
            return container == StoneVatBE.this || container instanceof CompoundContainer && ((CompoundContainer)container).contains((Container)StoneVatBE.this);
        }
    };

    public StoneVatBE(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.STONE_VAT_BE.get(), pos, blockState);
    }

    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(compound)) {
            ContainerHelper.loadAllItems((CompoundTag)compound, this.items, (HolderLookup.Provider)registries);
        }
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        if (!this.trySaveLootTable(compound)) {
            ContainerHelper.saveAllItems((CompoundTag)compound, this.items, (HolderLookup.Provider)registries);
        }
    }

    public int getContainerSize() {
        return this.items.size();
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"block.archaeological_research_exploration.stone_vat");
    }

    protected AbstractContainerMenu createMenu(int id, Inventory player) {
        return new DispenserMenu(id, player, (Container)this);
    }

    public void startOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.openersCounter.incrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.openersCounter.decrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    protected void signalOpenCount(Level level, BlockPos pos, BlockState state, int eventId, int eventParam) {
        Block block = state.getBlock();
        level.blockEvent(pos, block, 1, eventParam);
    }
}

