/*
 * Decompiled with CFR 0.152.
 */
package com.archaeological_research.exploration.blocks.stone;

import com.archaeological_research.exploration.blocks.recipe.CuttingRecipe;
import com.archaeological_research.exploration.blocks.stone.StoneWoodenPileBE;
import com.archaeological_research.exploration.item.tool.ModKnifeItme;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class StoneWoodenPileB
extends BaseEntityBlock {
    public static final MapCodec<StoneWoodenPileB> CODEC = StoneWoodenPileB.simpleCodec(StoneWoodenPileB::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), (VoxelShape)Block.box((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0));

    public StoneWoodenPileB(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new StoneWoodenPileBE(pos, state);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockentity = level.getBlockEntity(pos);
            if (blockentity instanceof StoneWoodenPileBE) {
                Containers.dropContents((Level)level, (BlockPos)pos, ((StoneWoodenPileBE)blockentity).getItems());
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack hand1;
        ItemStack itemstack;
        StoneWoodenPileBE blockEntity;
        Optional<RecipeHolder<CuttingRecipe>> recipe;
        BlockEntity blockEntity2 = level.getBlockEntity(pos);
        if (blockEntity2 instanceof StoneWoodenPileBE && (recipe = (blockEntity = (StoneWoodenPileBE)blockEntity2).getCookableRecipe(itemstack = (hand1 = player.getItemInHand(InteractionHand.MAIN_HAND)).getItem() instanceof ModKnifeItme ? player.getItemInHand(InteractionHand.OFF_HAND) : hand1)).isPresent() && blockEntity.placeItem((LivingEntity)player, itemstack, ((CuttingRecipe)recipe.get().value()).getProgress())) {
            level.playSound(null, pos, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 0.8f);
            player.awardStat(Stats.INTERACT_WITH_CAMPFIRE);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.CONSUME;
    }

    public static void makeParticles(Level level, BlockPos pos, ItemStack item) {
        Vec3 vec3 = new Vec3((double)level.getRandom().nextFloat() - 0.5, Math.random() * (double)0.1f + (double)0.1f, (double)level.getRandom().nextFloat() - 0.5);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, item), (double)pos.getX() + 0.5, (double)pos.getY() + 0.8, (double)pos.getZ() + 0.5, 1, vec3.x, vec3.y, vec3.z, 0.01);
        } else {
            level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, item), (double)pos.getX() + 0.5, (double)pos.getY() + 0.8, (double)pos.getZ() + 0.5, vec3.x, vec3.y, vec3.z);
        }
    }
}

