/*
 * Decompiled with CFR 0.152.
 */
package com.archaeological_research.exploration.data;

import com.archaeological_research.exploration.data.DatapackGenerator;
import com.archaeological_research.exploration.data.ModAdvancementProvider;
import com.archaeological_research.exploration.data.ModBlockLootTablesProvider;
import com.archaeological_research.exploration.data.ModBlockStateProvider;
import com.archaeological_research.exploration.data.ModBlockTagsProvider;
import com.archaeological_research.exploration.data.ModEntityLootTablesProvider;
import com.archaeological_research.exploration.data.ModGlobalLootModifierProvider;
import com.archaeological_research.exploration.data.ModItemModelsProvider;
import com.archaeological_research.exploration.data.ModItemTagsProvider;
import com.archaeological_research.exploration.data.ModLangCnProvider;
import com.archaeological_research.exploration.data.ModLangUsProvider;
import com.archaeological_research.exploration.data.ModRecipesProvider;
import com.archaeological_research.exploration.data.ModSuspiciousBlockProvider;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="archaeological_research_exploration")
public class DataGenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        net.minecraft.data.DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(ModBlockLootTablesProvider::new, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(ModEntityLootTablesProvider::new, LootContextParamSets.ENTITY), new LootTableProvider.SubProviderEntry(ModSuspiciousBlockProvider::new, LootContextParamSets.ARCHAEOLOGY)), lookupProvider));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelsProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModBlockStateProvider(packOutput, existingFileHelper));
        ModBlockTagsProvider blockTagsProvider = new ModBlockTagsProvider(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagsProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModLangUsProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new ModLangCnProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new DatapackGenerator(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipesProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ModGlobalLootModifierProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ModAdvancementProvider(packOutput, lookupProvider, existingFileHelper));
    }
}

