/*
 * Decompiled with CFR 0.152.
 */
package com.archaeological_research.exploration.data;

import com.archaeological_research.exploration.register.ModBlocks;
import com.archaeological_research.exploration.register.ModItems;
import java.util.LinkedHashMap;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;

public class ModItemModelsProvider
extends ItemModelProvider {
    private static final LinkedHashMap<ResourceKey<TrimMaterial>, Float> trimMaterials = new LinkedHashMap();

    public ModItemModelsProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "archaeological_research_exploration", existingFileHelper);
    }

    protected void registerModels() {
        this.wallItem(ModBlocks.MULBERRY_WALL, ModBlocks.MULBERRY_PLANKS);
        this.fenceItem(ModBlocks.MULBERRY_FENCE, ModBlocks.MULBERRY_PLANKS);
        this.wallItem(ModBlocks.LACQUER_WALL, ModBlocks.LACQUER_PLANKS);
        this.fenceItem(ModBlocks.LACQUER_FENCE, ModBlocks.LACQUER_PLANKS);
        this.wallItem(ModBlocks.KOREAN_PINE_WALL, ModBlocks.KOREAN_PINE_PLANKS);
        this.fenceItem(ModBlocks.KOREAN_PINE_FENCE, ModBlocks.KOREAN_PINE_PLANKS);
        this.wallItem(ModBlocks.PALM_WALL, ModBlocks.PALM_PLANKS);
        this.fenceItem(ModBlocks.PALM_FENCE, ModBlocks.PALM_PLANKS);
        this.wallItem(ModBlocks.TUBE_CORAL_BLOCK_BRICKS_WALL, ModBlocks.ANAMORPHIC_TUBE_CORAL_BLOCK);
        this.fenceItem(ModBlocks.TUBE_CORAL_BLOCK_BRICKS_FENCE, ModBlocks.ANAMORPHIC_TUBE_CORAL_BLOCK);
        this.wallItem(ModBlocks.BRAIN_CORAL_BLOCK_BRICKS_WALL, ModBlocks.ANAMORPHIC_BRAIN_CORAL_BLOCK);
        this.fenceItem(ModBlocks.BRAIN_CORAL_BLOCK_BRICKS_FENCE, ModBlocks.ANAMORPHIC_BRAIN_CORAL_BLOCK);
        this.wallItem(ModBlocks.BUBBLE_CORAL_BLOCK_BRICKS_WALL, ModBlocks.ANAMORPHIC_BUBBLE_CORAL_BLOCK);
        this.fenceItem(ModBlocks.BUBBLE_CORAL_BLOCK_BRICKS_FENCE, ModBlocks.ANAMORPHIC_BUBBLE_CORAL_BLOCK);
        this.wallItem(ModBlocks.FIRE_CORAL_BLOCK_BRICKS_WALL, ModBlocks.ANAMORPHIC_FIRE_CORAL_BLOCK);
        this.fenceItem(ModBlocks.FIRE_CORAL_BLOCK_BRICKS_FENCE, ModBlocks.ANAMORPHIC_FIRE_CORAL_BLOCK);
        this.wallItem(ModBlocks.HORN_CORAL_BLOCK_BRICKS_WALL, ModBlocks.ANAMORPHIC_HORN_CORAL_BLOCK);
        this.fenceItem(ModBlocks.HORN_CORAL_BLOCK_BRICKS_FENCE, ModBlocks.ANAMORPHIC_HORN_CORAL_BLOCK);
        this.wallItem(ModBlocks.DIRT_WALL, ModBlocks.DIRT_BRICKS);
        this.fenceItem(ModBlocks.DIRT_FENCE, ModBlocks.DIRT_BRICKS);
        this.wallItem(ModBlocks.TERRACOTTA_WALL, ModBlocks.TERRACOTTA_BRICKS);
        this.fenceItem(ModBlocks.TERRACOTTA_FENCE, ModBlocks.TERRACOTTA_BRICKS);
        this.wallItem(ModBlocks.FIRE_BRICKS_WALL, ModBlocks.FIRE_BRICKS);
        this.fenceItem(ModBlocks.FIRE_BRICKS_FENCE, ModBlocks.FIRE_BRICKS);
        this.wallItem(ModBlocks.GRASS_WALL, ModBlocks.GRASS_BLOCK);
        this.fenceItem(ModBlocks.GRASS_FENCE, ModBlocks.GRASS_BLOCK);
        this.wallItem(ModBlocks.GRASS_DRIED_WALL, ModBlocks.GRASS_DRIED_BLOCK);
        this.fenceItem(ModBlocks.GRASS_DRIED_FENCE, ModBlocks.GRASS_DRIED_BLOCK);
        this.wallItem(ModBlocks.BAMBOO_TUBE_WALL, ModBlocks.BAMBOO_TUBE_BLOCK);
        this.fenceItem(ModBlocks.BAMBOO_TUBE_FENCE, ModBlocks.BAMBOO_TUBE_BLOCK);
        this.basicItem((Item)ModItems.RAMIE_SEEDS.get());
        this.basicItem((Item)ModItems.MILLET_SEEDS.get());
        this.basicItem((Item)ModItems.FOXTAIL_MILLET_SEEDS.get());
        this.basicItem((Item)ModItems.SOYBEAN_SEEDS.get());
        this.basicItem((Item)ModItems.RICE_SEEDS.get());
        this.saplingItem(ModBlocks.MULBERRY_SAPLING);
        this.saplingItem(ModBlocks.LACQUER_SAPLING);
        this.saplingItem(ModBlocks.KOREAN_PINE_SAPLING);
        this.saplingItem(ModBlocks.PALM_SAPLING);
        this.basicItem((Item)ModItems.STONE_CORE.get());
        this.basicItem((Item)ModItems.POLISHED_STONE_CORE.get());
        this.basicItem((Item)ModItems.PALM_BARK.get());
        this.basicItem((Item)ModItems.PALM_FIBER.get());
        this.basicItem((Item)ModItems.RAMIE_FIBER.get());
        this.basicItem((Item)ModItems.DRIED_FIBER.get());
        this.basicItem((Item)ModItems.MILLET.get());
        this.basicItem((Item)ModItems.FOXTAIL_MILLET.get());
        this.basicItem((Item)ModItems.SOYBEAN.get());
        this.basicItem((Item)ModItems.RICE.get());
        this.basicItem((Item)ModItems.RAMIE_THREAD.get());
        this.basicItem((Item)ModItems.RAMIE_ROPE.get());
        this.basicItem((Item)ModItems.RAMIE_FABRIC.get());
        this.basicItem((Item)ModItems.RAW_LACQUER.get());
        this.basicItem((Item)ModItems.PINE_RESIN.get());
        this.basicItem((Item)ModItems.MIXED_RESIN.get());
        this.basicItem((Item)ModItems.MIXED_COATING.get());
        this.basicItem((Item)ModItems.VARNISHED_STICK.get());
        this.basicItem((Item)ModItems.PRESERVED_STICK.get());
        this.basicItem((Item)ModItems.BAMBOO_TUBE.get());
        this.basicItem((Item)ModItems.BAMBOO_LEAVES.get());
        this.basicItem((Item)ModItems.BAMBOO_FIBER.get());
        this.basicItem((Item)ModItems.WET_PAPER.get());
        this.basicItem((Item)ModItems.CARDBOARD.get());
        this.basicItem((Item)ModItems.PELT.get());
        this.basicItem((Item)ModItems.PELT_SOAKED.get());
        this.basicItem((Item)ModItems.PELT_SCRAPED.get());
        this.basicItem((Item)ModItems.LEATHER_ROPE.get());
        this.basicItem((Item)ModItems.FINE_FABRIC.get());
        this.basicItem((Item)ModItems.SILKWORM.get());
        this.basicItem((Item)ModItems.SILKWORM_COCOON.get());
        this.basicItem((Item)ModItems.SILKWORM_SILK.get());
        this.basicItem((Item)ModItems.SILK_FABRIC.get());
        this.basicItem((Item)ModItems.DRIFT_WOOD.get());
        this.basicItem((Item)ModItems.FISH_BLADDER.get());
        this.basicItem((Item)ModItems.FISH_GLUE.get());
        this.basicItem((Item)ModItems.GOURD.get());
        this.basicItem((Item)ModItems.PETAL_WHITE.get());
        this.basicItem((Item)ModItems.PETAL_LIGHT_GRAY.get());
        this.basicItem((Item)ModItems.PETAL_RED.get());
        this.basicItem((Item)ModItems.PETAL_ORANGE.get());
        this.basicItem((Item)ModItems.PETAL_YELLOW.get());
        this.basicItem((Item)ModItems.PETAL_LIGHT_BLUE.get());
        this.basicItem((Item)ModItems.PETAL_BLUE.get());
        this.basicItem((Item)ModItems.PETAL_MAGENTA.get());
        this.basicItem((Item)ModItems.PETAL_PINK.get());
        this.basicItem((Item)ModItems.PETAL_CYAN.get());
        this.basicItem((Item)ModItems.WOOD_DUST.get());
        this.basicItem((Item)ModItems.DIRT_BALL.get());
        this.basicItem((Item)ModItems.CHINA_CLAY_BALL.get());
        this.basicItem((Item)ModItems.BAUXITE_CLAY_BALL.get());
        this.basicItem((Item)ModItems.SULFUR_ROCK.get());
        this.basicItem((Item)ModItems.SULFUR_DUST.get());
        this.basicItem((Item)ModItems.NITER_ROCK.get());
        this.basicItem((Item)ModItems.NITER_DUST.get());
        this.basicItem((Item)ModItems.DIRT_EMBRYO.get());
        this.basicItem((Item)ModItems.CLAY_EMBRYO.get());
        this.basicItem((Item)ModItems.TERRACOTTA_EMBRYO.get());
        this.basicItem((Item)ModItems.REFRACTORY_CLAY_EMBRYO.get());
        this.basicItem((Item)ModItems.SEED_COOKED.get());
        this.basicItem((Item)ModItems.FRIED_EGG.get());
        this.basicItem((Item)ModItems.SASHIMI.get());
        this.basicItem((Item)ModItems.GRILLED_FISH_FILLET.get());
        this.basicItem((Item)ModItems.SMALL_DRIED_FISH.get());
        this.basicItem((Item)ModItems.RAW_CALF_MEAT.get());
        this.basicItem((Item)ModItems.COOKED_CALF_MEAT.get());
        this.basicItem((Item)ModItems.RAW_MEAT.get());
        this.basicItem((Item)ModItems.COOKED_MEAT.get());
        this.basicItem((Item)ModItems.JERKY_SHODDY.get());
        this.basicItem((Item)ModItems.JERKY.get());
        this.basicItem((Item)ModItems.JERKY_SLAB.get());
        this.basicItem((Item)ModItems.SUSPICIOUS_STEW.get());
        this.handheldItem((Item)ModItems.BAMBOO_IGNITER.get());
        this.handheldItem((Item)ModItems.PALM_FIBER_BRUSH.get());
        this.handheldItem((Item)ModItems.ARCHAEOLOGY_BRUSH.get());
        this.basicItem((Item)ModItems.ARTISAN_BOARD.get());
        this.basicItem((Item)ModItems.CRAFTING_BOARD.get());
        this.basicItem((Item)ModItems.SMITHING_BOARD.get());
        this.handheldItem((Item)ModItems.DIPPER.get());
        this.handheldItem((Item)ModItems.DIPPER_WATER.get());
        this.basicItem((Item)ModItems.PAPER_BOX.get());
        this.handheldItem((Item)ModItems.POLISHED_KNIFE.get());
        this.handheldItem((Item)ModItems.POLISHED_HAMMER.get());
        this.handheldItem((Item)ModItems.POLISHED_SHOVEL.get());
        this.handheldItem((Item)ModItems.POLISHED_PICKAXE.get());
        this.handheldItem((Item)ModItems.POLISHED_AXE.get());
        this.handheldItem((Item)ModItems.POLISHED_HOE.get());
        this.handheldItem((Item)ModItems.ANCIENT_ALLOY_SHOVEL.get());
        this.handheldItem((Item)ModItems.ANCIENT_ALLOY_PICKAXE.get());
        this.handheldItem((Item)ModItems.ANCIENT_ALLOY_AXE.get());
        this.handheldItem((Item)ModItems.ANCIENT_ALLOY_HOE.get());
        this.basicItem((Item)ModItems.THROW_STONE.get());
        this.handheldItem((Item)ModItems.POLISHED_SWORD.get());
        this.handheldItem((Item)ModItems.ANCIENT_ALLOY_SWORD.get());
        this.basicItem((Item)ModItems.GARLAND.get());
        this.basicItem((Item)ModItems.BAMBOO_HAT.get());
        this.trimmedArmorItem(ModItems.PALM_FIBER_CAPE);
        this.trimmedArmorItem(ModItems.ANCIENT_ALLOY_BOOTS);
        this.trimmedArmorItem(ModItems.ANCIENT_ALLOY_HELMET);
        this.trimmedArmorItem(ModItems.ANCIENT_ALLOY_CHESTPLATE);
        this.trimmedArmorItem(ModItems.ANCIENT_ALLOY_LEGGINGS);
        this.trimmedArmorItem(ModItems.IMPROVED_CHAINMAIL_CHESTPLATE);
        this.trimmedArmorItem(ModItems.IMPROVED_IRON_CHESTPLATE);
        this.trimmedArmorItem(ModItems.IMPROVED_GOLDEN_CHESTPLATE);
        this.trimmedArmorItem(ModItems.IMPROVED_DIAMOND_CHESTPLATE);
        this.trimmedArmorItem(ModItems.IMPROVED_NETHERITE_CHESTPLATE);
        this.basicItem((Item)ModItems.ARCHAEOLOGICAL_NOTES.get());
        this.handheldItem((Item)ModItems.ARCHAEOLOGICAL_TROWEL.get());
        this.basicItem((Item)ModItems.SEASHELL.get());
        this.basicItem((Item)ModItems.ANAMORPHIC_OCTOPUS.get());
        this.basicItem((Item)ModItems.ANCIENT_ALLOY_INGOT.get());
        this.basicItem((Item)ModItems.FOSSIL_NODULE_COAL.get());
        this.basicItem((Item)ModItems.FOSSIL_NODULE_IRON.get());
        this.basicItem((Item)ModItems.FOSSIL_NODULE_LAPIS.get());
        this.basicItem((Item)ModItems.FOSSIL_NODULE_COPPER.get());
        this.basicItem((Item)ModItems.FOSSIL_NODULE_GOLD.get());
        this.basicItem((Item)ModItems.FOSSIL_NODULE_REDSTONE.get());
        this.basicItem((Item)ModItems.FOSSIL_NODULE_EMERALD.get());
        this.basicItem((Item)ModItems.FOSSIL_NODULE_DIAMOND.get());
        this.basicItem((Item)ModItems.FOSSIL_NODULE_QUARTZ.get());
        this.basicItem((Item)ModItems.FOSSIL_NODULE_GLOWSTONE.get());
    }

    private void fenceItem(DeferredBlock<?> block, DeferredBlock<?> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(block.getId().getPath(), this.mcLoc("block/fence_inventory"))).texture("texture", ResourceLocation.fromNamespaceAndPath((String)"archaeological_research_exploration", (String)("block/" + baseBlock.getId().getPath())));
    }

    private void wallItem(DeferredBlock<?> block, DeferredBlock<?> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(block.getId().getPath(), this.mcLoc("block/wall_inventory"))).texture("wall", ResourceLocation.fromNamespaceAndPath((String)"archaeological_research_exploration", (String)("block/" + baseBlock.getId().getPath())));
    }

    private void saplingItem(DeferredBlock<?> block) {
        ((ItemModelBuilder)this.withExistingParent(block.getId().getPath(), ResourceLocation.parse((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"archaeological_research_exploration", (String)("block/" + block.getId().getPath())));
    }

    private void trimmedArmorItem(DeferredItem<ArmorItem> itemDeferredItem) {
        String MOD_ID = "archaeological_research_exploration";
        Object object = itemDeferredItem.get();
        if (object instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)object;
            trimMaterials.forEach((trimMaterial, value) -> {
                float trimValue = value.floatValue();
                String armorType = switch (armorItem.getEquipmentSlot()) {
                    case EquipmentSlot.HEAD -> "helmet";
                    case EquipmentSlot.CHEST -> "chestplate";
                    case EquipmentSlot.LEGS -> "leggings";
                    case EquipmentSlot.FEET -> "boots";
                    default -> "";
                };
                String armorItemPath = armorItem.toString();
                String trimPath = "trims/items/" + armorType + "_trim_" + trimMaterial.location().getPath();
                String currentTrimName = armorItemPath + "_" + trimMaterial.location().getPath() + "_trim";
                ResourceLocation armorItemResLoc = ResourceLocation.parse((String)armorItemPath);
                ResourceLocation trimResLoc = ResourceLocation.parse((String)trimPath);
                ResourceLocation trimNameResLoc = ResourceLocation.parse((String)currentTrimName);
                this.existingFileHelper.trackGenerated(trimResLoc, PackType.CLIENT_RESOURCES, ".png", "textures");
                ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(currentTrimName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", armorItemResLoc.getNamespace() + ":item/" + armorItemResLoc.getPath())).texture("layer1", trimResLoc);
                ((ItemModelBuilder)this.withExistingParent(itemDeferredItem.getId().getPath(), this.mcLoc("item/generated"))).override().model((ModelFile)new ModelFile.UncheckedModelFile(trimNameResLoc.getNamespace() + ":item/" + trimNameResLoc.getPath())).predicate(this.mcLoc("trim_type"), trimValue).end().texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"archaeological_research_exploration", (String)("item/" + itemDeferredItem.getId().getPath())));
            });
        }
    }

    static {
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.QUARTZ, Float.valueOf(0.1f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.IRON, Float.valueOf(0.2f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.NETHERITE, Float.valueOf(0.3f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.REDSTONE, Float.valueOf(0.4f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.COPPER, Float.valueOf(0.5f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.GOLD, Float.valueOf(0.6f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.EMERALD, Float.valueOf(0.7f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.DIAMOND, Float.valueOf(0.8f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.LAPIS, Float.valueOf(0.9f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.AMETHYST, Float.valueOf(1.0f));
    }
}

