/*
 * Decompiled with CFR 0.152.
 */
package com.archaeological_research.exploration.item.combot;

import com.archaeological_research.exploration.item.combot.ThrowStoneSpearIE;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;

public class ThrowStoneSpearI
extends Item
implements ProjectileItem {
    public ThrowStoneSpearI(Item.Properties properties) {
        super(properties);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 100;
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            float f;
            Player player = (Player)entityLiving;
            int i = this.getUseDuration(stack, entityLiving) - timeLeft;
            if (i >= 10 && (!((f = EnchantmentHelper.getTridentSpinAttackStrength((ItemStack)stack, (LivingEntity)player)) > 0.0f) || player.isInWaterOrRain())) {
                Holder holder = EnchantmentHelper.pickHighestLevel((ItemStack)stack, (DataComponentType)EnchantmentEffectComponents.TRIDENT_SOUND).orElse(SoundEvents.TRIDENT_THROW);
                if (!level.isClientSide) {
                    stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)entityLiving.getUsedItemHand()));
                    player.getCooldowns().addCooldown(stack.getItem(), 20);
                    ThrowStoneSpearIE PolishedSpear = new ThrowStoneSpearIE(level, (LivingEntity)player);
                    PolishedSpear.shootFromRotation((Entity)player, player.getXRot(), player.getYRot() - 1.0f, 0.0f, 2.5f, 1.0f);
                    level.addFreshEntity((Entity)PolishedSpear);
                    level.playSound(null, (Entity)PolishedSpear, (SoundEvent)holder.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (!player.hasInfiniteMaterials()) {
                        stack.consume(1, (LivingEntity)player);
                    }
                }
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pUsedHand);
        pPlayer.startUsingItem(pUsedHand);
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public Projectile asProjectile(Level level, Position pos, ItemStack stack, Direction direction) {
        ThrowStoneSpearIE PolishedSpear = new ThrowStoneSpearIE(level, pos.x(), pos.y(), pos.z());
        PolishedSpear.setItem(stack);
        return PolishedSpear;
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return ItemAbilities.DEFAULT_TRIDENT_ACTIONS.contains(itemAbility);
    }
}

