/*
 * Decompiled with CFR 0.152.
 */
package com.archaeological_research.exploration.item.tool;

import com.archaeological_research.exploration.item.tool.CraftingBoardMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CraftingBoardItem
extends Item {
    private static final Component TITLE = Component.translatable((String)"container.crafting");

    public CraftingBoardItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (level.isClientSide) {
            return InteractionResultHolder.success((Object)itemstack);
        }
        player.openMenu(this.getMenuProvider(level, level.getSharedSpawnPos()));
        itemstack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
        player.awardStat(Stats.INTERACT_WITH_CRAFTING_TABLE);
        return InteractionResultHolder.consume((Object)itemstack);
    }

    protected MenuProvider getMenuProvider(Level level, BlockPos pos) {
        return new SimpleMenuProvider((syncId, inventory, player) -> new CraftingBoardMenu(syncId, inventory, ContainerLevelAccess.create((Level)level, (BlockPos)pos)), TITLE);
    }
}

