/*
 * Decompiled with CFR 0.152.
 */
package com.archaeological_research.exploration.item.tool;

import com.archaeological_research.exploration.register.ModItems;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class ModBucketItem
extends BucketItem {
    public final Fluid content;

    public ModBucketItem(Fluid content, Item.Properties properties) {
        super(content, properties);
        this.content = content;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        BlockPos blockpos2;
        ItemStack itemstack = player.getItemInHand(hand);
        BlockHitResult blockhitresult = ModBucketItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)(this.content == Fluids.EMPTY ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE));
        if (blockhitresult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        if (blockhitresult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        BlockPos blockpos = blockhitresult.getBlockPos();
        Direction direction = blockhitresult.getDirection();
        BlockPos blockpos1 = blockpos.relative(direction);
        if (!level.mayInteract(player, blockpos) || !player.mayUseItemAt(blockpos1, direction, itemstack)) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        if (this.content == Fluids.EMPTY) {
            BlockState blockstate1 = level.getBlockState(blockpos);
            Fluid fluid = blockstate1.getFluidState().getType();
            Block block = blockstate1.getBlock();
            if (block instanceof BucketPickup) {
                ItemStack itemstack3;
                BucketPickup bucketpickup = (BucketPickup)block;
                if (fluid == Fluids.WATER && !(itemstack3 = bucketpickup.pickupBlock(player, (LevelAccessor)level, blockpos, blockstate1)).isEmpty()) {
                    itemstack3 = new ItemStack((ItemLike)ModItems.DIPPER_WATER.get());
                    player.awardStat(Stats.ITEM_USED.get((Object)this));
                    bucketpickup.getPickupSound(blockstate1).ifPresent(p_150709_ -> player.playSound(p_150709_, 1.0f, 1.0f));
                    level.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PICKUP, blockpos);
                    ItemStack itemstack2 = ItemUtils.createFilledResult((ItemStack)itemstack, (Player)player, (ItemStack)itemstack3);
                    if (!level.isClientSide) {
                        CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)player, itemstack3);
                    }
                    return InteractionResultHolder.sidedSuccess((Object)itemstack2, (boolean)level.isClientSide());
                }
            }
            return InteractionResultHolder.fail((Object)itemstack);
        }
        BlockState blockstate = level.getBlockState(blockpos);
        BlockPos blockPos = blockpos2 = this.canBlockContainFluid(player, level, blockpos, blockstate) ? blockpos : blockpos1;
        if (this.emptyContents(player, level, blockpos2, blockhitresult, itemstack)) {
            this.checkExtraContent(player, level, itemstack, blockpos2);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, blockpos2, itemstack);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            ItemStack itemstack1 = ItemUtils.createFilledResult((ItemStack)itemstack, (Player)player, (ItemStack)ModBucketItem.getEmptySuccessItem(itemstack, player));
            return InteractionResultHolder.sidedSuccess((Object)itemstack1, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }

    public static ItemStack getEmptySuccessItem(ItemStack bucketStack, Player player) {
        return !player.hasInfiniteMaterials() ? new ItemStack((ItemLike)ModItems.DIPPER.get()) : bucketStack;
    }
}

